/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.TreeSet;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class WriteLegacyClasspath
extends DefaultTask {
    @Inject
    public WriteLegacyClasspath() {
    }

    @Input
    abstract ListProperty<String> getEntries();

    void addEntries(Object ... filesNotation) {
        ConfigurableFileCollection files = this.getProject().files(filesNotation);
        this.getEntries().addAll(this.getProject().provider(() -> files.getFiles().stream().filter(file -> file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip")).map(File::getAbsolutePath).toList()));
    }

    @OutputFile
    abstract RegularFileProperty getLegacyClasspathFile();

    @TaskAction
    public void writeLegacyClasspath() throws IOException {
        StringBuilder legacyClasspath = new StringBuilder();
        for (String entry : new TreeSet((Collection)this.getEntries().get())) {
            legacyClasspath.append(entry).append(System.lineSeparator());
        }
        Path destination = ((File)this.getLegacyClasspathFile().getAsFile().get()).toPath();
        FileUtils.writeStringSafe(destination, legacyClasspath.toString(), StandardCharsets.UTF_8);
    }
}

