/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc.writer;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.moddev.shadow.com.google.gson.JsonArray;
import net.neoforged.moddev.shadow.com.google.gson.JsonElement;
import net.neoforged.moddev.shadow.com.google.gson.JsonObject;
import net.neoforged.moddev.shadow.com.google.gson.JsonParseException;
import net.neoforged.moddev.shadow.com.google.gson.JsonPrimitive;

public class JsonUtils {
    public static String getStringOrKeep(JsonObject object, String key) {
        return object == null ? null : JsonUtils.getStringOrSetDefault(object, key, null);
    }

    public static String getStringOrSetDefault(JsonObject object, String key, String defaultValue) {
        JsonElement element = object.get(key);
        if (element == null) {
            if (defaultValue != null) {
                object.addProperty(key, defaultValue);
            }
            return defaultValue;
        }
        if (!element.isJsonPrimitive()) {
            if (defaultValue == null) {
                return null;
            }
            throw new JsonParseException(key + " is not a string");
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isString()) {
            if (defaultValue == null) {
                return null;
            }
            throw new JsonParseException(key + " is not a string");
        }
        return primitive.getAsString();
    }

    public static JsonArray getArrayOrKeep(JsonObject object, String key) {
        return object == null ? null : JsonUtils.getArrayOrSetDefault(object, key, null);
    }

    public static JsonArray getArrayOrSetDefault(JsonObject object, String key, JsonArray defaultValue) {
        JsonElement element = object.get(key);
        if (element == null) {
            if (defaultValue != null) {
                object.add(key, defaultValue);
            }
            return defaultValue;
        }
        if (!element.isJsonArray()) {
            if (defaultValue == null) {
                return null;
            }
            throw new JsonParseException(key + " is not an json array");
        }
        return element.getAsJsonArray();
    }

    public static JsonObject getObjectOrKeep(JsonObject object, String key) {
        return object == null ? null : JsonUtils.getObjectOrSetDefault(object, key, null);
    }

    public static JsonObject getObjectOrSetDefault(JsonObject object, String key, JsonObject defaultValue) {
        JsonElement element = object.get(key);
        if (element == null) {
            if (defaultValue != null) {
                object.add(key, defaultValue);
            }
            return defaultValue;
        }
        if (!element.isJsonObject()) {
            if (defaultValue == null) {
                return null;
            }
            throw new JsonParseException(key + " is not an json array");
        }
        return element.getAsJsonObject();
    }

    public static List<JsonObject> getObjectsFromArray(JsonArray array) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) continue;
            result.add(element.getAsJsonObject());
        }
        return result;
    }
}

