/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.moddevgradle.dsl.VersionCapabilities;
import net.neoforged.moddevgradle.internal.generated.MinecraftVersionList;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public record VersionCapabilitiesInternal(String minecraftVersion, int javaVersion, boolean splitDataRuns, boolean testFixtures, boolean modLocatorRework, boolean legacyClasspath) implements VersionCapabilities,
Serializable
{
    private static final Logger LOG = Logging.getLogger(VersionCapabilitiesInternal.class);
    private static final VersionCapabilitiesInternal LATEST = VersionCapabilitiesInternal.ofVersionIndex(0);
    private static final Pattern NEOFORGE_PATTERN = Pattern.compile("^(\\d+\\.\\d+)\\.\\d+(|-.*)$");
    private static final Pattern NEOFORM_PATTERN = Pattern.compile("^(.*)-(?:\\+|\\d{8}\\.\\d{6})$");
    private static final int MC_1_21_9_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("1.21.9");
    private static final int MC_24W45A_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("24w45a");
    private static final int MC_1_20_5_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("1.20.5");
    private static final int MC_24W14A_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("24w14a");
    private static final int MC_1_20_4_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("1.20.4");
    private static final int MC_1_18_PRE2_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("1.18-pre2");
    private static final int MC_21W19A_INDEX = VersionCapabilitiesInternal.getReferenceVersionIndex("21w19a");

    public static VersionCapabilitiesInternal latest() {
        return LATEST;
    }

    public static VersionCapabilitiesInternal ofMinecraftVersion(String minecraftVersion) {
        int versionIndex = MinecraftVersionList.VERSIONS.indexOf(minecraftVersion);
        if (versionIndex == -1) {
            LOG.lifecycle("Minecraft Version {} is unknown. Assuming latest capabilities.", new Object[]{versionIndex});
            return LATEST.withMinecraftVersion(minecraftVersion);
        }
        return VersionCapabilitiesInternal.ofVersionIndex(versionIndex);
    }

    public static VersionCapabilitiesInternal ofVersionIndex(int versionIndex) {
        String minecraftVersion = MinecraftVersionList.VERSIONS.get(versionIndex);
        return VersionCapabilitiesInternal.ofVersionIndex(versionIndex, minecraftVersion);
    }

    public static VersionCapabilitiesInternal ofVersionIndex(int versionIndex, String minecraftVersion) {
        int javaVersion = VersionCapabilitiesInternal.getJavaVersion(versionIndex);
        boolean splitData = VersionCapabilitiesInternal.hasSplitDataEntrypoints(versionIndex);
        boolean testFixtures = VersionCapabilitiesInternal.hasTestFixtures(versionIndex);
        boolean modLocatorRework = VersionCapabilitiesInternal.hasModLocatorRework(versionIndex);
        boolean legacyClasspath = VersionCapabilitiesInternal.hasLegacyClasspath(versionIndex);
        return new VersionCapabilitiesInternal(minecraftVersion, javaVersion, splitData, testFixtures, modLocatorRework, legacyClasspath);
    }

    static int getJavaVersion(int versionIndex) {
        if (versionIndex <= MC_24W14A_INDEX) {
            return 21;
        }
        if (versionIndex <= MC_1_18_PRE2_INDEX) {
            return 17;
        }
        if (versionIndex <= MC_21W19A_INDEX) {
            return 16;
        }
        return 8;
    }

    static boolean hasSplitDataEntrypoints(int versionIndex) {
        return versionIndex <= MC_24W45A_INDEX;
    }

    static boolean hasTestFixtures(int versionIndex) {
        return versionIndex <= MC_1_20_4_INDEX;
    }

    static boolean hasModLocatorRework(int versionIndex) {
        return versionIndex <= MC_1_20_5_INDEX;
    }

    static boolean hasLegacyClasspath(int versionIndex) {
        return versionIndex > MC_1_21_9_INDEX;
    }

    static int indexOfNeoForgeVersion(String version) {
        Matcher matcher = NEOFORGE_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return -1;
        }
        Object mcVersion = "1." + matcher.group(1);
        if (((String)mcVersion).endsWith(".0")) {
            mcVersion = ((String)mcVersion).substring(0, ((String)mcVersion).length() - 2);
        }
        return MinecraftVersionList.VERSIONS.indexOf(mcVersion);
    }

    public static VersionCapabilitiesInternal ofNeoForgeVersion(String version) {
        int index = VersionCapabilitiesInternal.indexOfNeoForgeVersion(version);
        if (index == -1) {
            VersionCapabilitiesInternal capabilities = LATEST;
            Matcher m = NEOFORGE_PATTERN.matcher(version);
            if (m.matches()) {
                Object minecraftVersion = "1." + m.group(1);
                if (((String)minecraftVersion).endsWith(".0")) {
                    minecraftVersion = ((String)minecraftVersion).substring(0, ((String)minecraftVersion).length() - 2);
                }
                capabilities = capabilities.withMinecraftVersion((String)minecraftVersion);
            }
            LOG.lifecycle("Failed to parse MC version from NeoForge version {}. Using capabilities of latest known Minecraft version with Minecraft version {}.", new Object[]{version, capabilities.minecraftVersion()});
            return capabilities;
        }
        return VersionCapabilitiesInternal.ofVersionIndex(index);
    }

    public static VersionCapabilitiesInternal ofNeoFormVersion(String version) {
        int index = MinecraftVersionList.indexOfByPrefix(version, "-");
        if (index == -1) {
            VersionCapabilitiesInternal capabilities = LATEST;
            Matcher m = NEOFORM_PATTERN.matcher(version);
            capabilities = m.matches() ? capabilities.withMinecraftVersion(m.group(1)) : capabilities.withMinecraftVersion(version);
            LOG.lifecycle("Failed to parse MC version from NeoForm version {}. Using capabilities of latest known Minecraft version with Minecraft version {}.", new Object[]{version, capabilities.minecraftVersion()});
            return capabilities;
        }
        return VersionCapabilitiesInternal.ofVersionIndex(index);
    }

    static int indexOfForgeVersion(String version) {
        return MinecraftVersionList.indexOfByPrefix(version, "-");
    }

    public static VersionCapabilitiesInternal ofForgeVersion(String version) {
        int index = VersionCapabilitiesInternal.indexOfForgeVersion(version);
        if (index == -1) {
            LOG.lifecycle("Failed to parse MC version from Forge version {}. Using capabilities of latest known Minecraft version.", new Object[]{version});
            return LATEST;
        }
        return VersionCapabilitiesInternal.ofVersionIndex(index);
    }

    private static int getReferenceVersionIndex(String v) {
        int idx = MinecraftVersionList.VERSIONS.indexOf(v);
        if (idx == -1) {
            throw new IllegalArgumentException("Reference version " + v + " is not in version list!");
        }
        return idx;
    }

    public VersionCapabilitiesInternal withMinecraftVersion(String minecraftVersion) {
        return new VersionCapabilitiesInternal(minecraftVersion, this.javaVersion, this.splitDataRuns, this.testFixtures, this.modLocatorRework, this.legacyClasspath);
    }
}

