/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class RunGameTask
extends JavaExec {
    @Classpath
    @InputFiles
    public abstract ConfigurableFileCollection getClasspathProvider();

    @Input
    public abstract MapProperty<String, String> getEnvironmentProperty();

    @Internal
    public abstract DirectoryProperty getGameDirectory();

    @Inject
    public RunGameTask() {
    }

    @TaskAction
    public void exec() {
        File runDir = ((Directory)this.getGameDirectory().get()).getAsFile();
        try {
            Files.createDirectories(runDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create run directory", e);
        }
        this.getEnvironment().putAll((Map)this.getEnvironmentProperty().get());
        this.classpath(new Object[]{this.getClasspathProvider()});
        this.setWorkingDir(runDir);
        super.exec();
    }
}

