/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.tasks;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.NetworkSettingPassthrough;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.ExecOperations;

public abstract class RemapOperation
implements Serializable {
    @Inject
    public RemapOperation() {
    }

    @Input
    public abstract Property<ToolType> getToolType();

    @Classpath
    @InputFiles
    public abstract ConfigurableFileCollection getToolClasspath();

    @Internal
    protected abstract RegularFileProperty getLogFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getMappings();

    public void execute(ExecOperations operations, File input, File output, FileCollection libraries) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--input", input.getAbsolutePath()));
        args.addAll(Arrays.asList("--output", output.getAbsolutePath()));
        if (this.getToolType().get() == ToolType.ART) {
            this.getMappings().forEach(file -> args.addAll(Arrays.asList("--names", file.getAbsolutePath())));
            libraries.forEach(lib -> args.addAll(Arrays.asList("--lib", lib.getAbsolutePath())));
            args.add("--disable-abstract-param");
            args.add("--strip-sigs");
        } else {
            args.addAll(Arrays.asList("--task", "SRG_TO_MCP"));
            this.getMappings().forEach(file -> args.addAll(Arrays.asList("--mcp", file.getAbsolutePath())));
            args.add("--strip-signatures");
        }
        try (OutputStream log = this.getLogFile().isPresent() ? Files.newOutputStream(((RegularFile)this.getLogFile().get()).getAsFile().toPath(), new OpenOption[0]) : new OutputStream(){

            @Override
            public void write(int b) {
            }
        };){
            operations.javaexec(execSpec -> {
                execSpec.systemProperties(NetworkSettingPassthrough.getNetworkSystemProperties());
                execSpec.jvmArgs(new Object[]{"-Dstdout.encoding=UTF-8", "-Dstderr.encoding=UTF-8"});
                execSpec.classpath(new Object[]{this.getToolClasspath()});
                execSpec.args((Iterable)args);
                execSpec.setStandardOutput(log);
            }).rethrowFailure().assertNormalExitValue();
        }
    }

    public static enum ToolType {
        ART,
        INSTALLER_TOOLS;

    }
}

