/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import javax.inject.Inject;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;

abstract class IntelliJOutputDirectoryValueSource
implements ValueSource<String, Params> {
    @Language(value="xpath")
    private static final String IDEA_DELEGATED_BUILD_XPATH = "/project/component[@name='GradleSettings']/option[@name='linkedExternalProjectsSettings']/GradleProjectSettings/option[@name='delegatedBuild']/@value";
    @Language(value="xpath")
    private static final String IDEA_OUTPUT_XPATH = "/project/component[@name='ProjectRootManager']/output/@url";

    @Inject
    public IntelliJOutputDirectoryValueSource() {
    }

    @Nullable
    static Function<Project, File> getIntellijOutputDirectory(Project project) {
        Provider outputDirSetting = project.getProviders().of(IntelliJOutputDirectoryValueSource.class, spec -> ((Params)spec.getParameters()).getProjectDir().set((Object)IntelliJOutputDirectoryValueSource.getRootGradleProjectDir(project).getAbsolutePath()));
        if (!outputDirSetting.isPresent()) {
            return null;
        }
        String outputDirTemplate = (String)outputDirSetting.get();
        return p -> new File(outputDirTemplate.replace("$PROJECT_DIR$", p.getProjectDir().getAbsolutePath()));
    }

    @Nullable
    public String obtain() {
        File gradleProjectDir = new File((String)((Params)this.getParameters()).getProjectDir().get());
        File ideaDir = new File(gradleProjectDir, ".idea");
        if (!ideaDir.exists()) {
            return null;
        }
        File gradleXml = new File(ideaDir, "gradle.xml");
        String delegatedBuild = IntelliJOutputDirectoryValueSource.evaluateXPath(gradleXml, IDEA_DELEGATED_BUILD_XPATH);
        if (!"false".equals(delegatedBuild)) {
            return null;
        }
        File miscXml = new File(ideaDir, "misc.xml");
        String outputDirUrl = IntelliJOutputDirectoryValueSource.evaluateXPath(miscXml, IDEA_OUTPUT_XPATH);
        if (outputDirUrl == null) {
            outputDirUrl = "file://$PROJECT_DIR$/out";
        }
        return outputDirUrl.replaceAll("^file:", "");
    }

    @Nullable
    private static String evaluateXPath(File file, @Language(value="xpath") String expression) {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            String result = XPathFactory.newInstance().newXPath().evaluate(expression, new InputSource(fis));
            string = result.isBlank() ? null : result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | XPathExpressionException ignored) {
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to evaluate xpath " + expression + " on file " + file, e);
            }
        }
        fis.close();
        return string;
    }

    private static File getRootGradleProjectDir(Project project) {
        Gradle root = project.getGradle().getParent();
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return root.getRootProject().getProjectDir();
        }
        return project.getRootDir();
    }

    static interface Params
    extends ValueSourceParameters {
        public Property<String> getProjectDir();
    }
}

