/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.neoforged.moddev.shadow.com.google.gson.Gson;
import net.neoforged.moddev.shadow.com.google.gson.GsonBuilder;
import net.neoforged.moddev.shadow.com.google.gson.JsonArray;
import net.neoforged.moddev.shadow.com.google.gson.JsonElement;
import net.neoforged.moddev.shadow.com.google.gson.JsonObject;
import net.neoforged.moddev.shadow.com.google.gson.JsonParseException;
import net.neoforged.moddev.shadow.com.google.gson.JsonStreamParser;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.AttachConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.BatchedLaunchWriter;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.JavaConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.LaunchConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.ConsoleType;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.InternalConsoleBehaviour;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.LaunchGroupEntry;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.PathWritable;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.RequestType;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.ShortCmdBehaviour;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.IWriter;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.JsonUtils;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.WritingMode;

public class LaunchJsonV0_2_0
implements IWriter {
    private static final String VERSION_KEY = "version";
    private static final String VERSION_VALUE = "0.2.0";
    private static final String CONFIGURATIONS_KEY = "configurations";
    private static final String CFG_TYPE_KEY = "type";
    private static final String CFG_NAME_KEY = "name";
    private static final String CFG_REQUEST_KEY = "request";
    private static final String CFG_PRESENTATION_KEY = "presentation";
    private static final String PRESENTATION_GROUP_KEY = "group";
    private static final String PRESENTATION_INDEX_KEY = "order";
    private static final String PRESENTATION_VISIBILITY_KEY = "hidden";
    private static final String CFG_PRE_TASK_KEY = "preLaunchTask";
    private static final String CFG_POST_TAKS_KEY = "postDebugTask";
    private static final String CFG_INTERNAL_CONSOLE_BEHAVIOUR_KEY = "internalConsoleOptions";
    private static final String CFG_JAVA_PROJECT_NAME_KEY = "projectName";
    private static final String CFG_JAVA_SOURCE_PATHS_KEY = "sourcePaths";
    private static final String CFG_JAVA_STEP_FILTERS_KEY = "stepFilters";
    private static final String CFG_LAUNCH_MAIN_CLASS_KEY = "mainClass";
    private static final String CFG_LAUNCH_ARGUMENTS_KEY = "args";
    private static final String CFG_LAUNCH_MODULE_PATHS_KEY = "modulePaths";
    private static final String CFG_LAUNCH_CLASS_PATHS_KEY = "classPaths";
    private static final String CFG_LAUNCH_ENCODING_KEY = "encoding";
    private static final String CFG_LAUNCH_VM_ARGUMENTS_KEY = "vmArgs";
    private static final String CFG_LAUNCH_WORKING_DIRECTORY_KEY = "cwd";
    private static final String CFG_LAUNCH_ENVIRONMENT_PROPS_KEY = "env";
    private static final String CFG_LAUNCH_ENVIRONMENT_FILE_KEY = "envFile";
    private static final String CFG_LAUNCH_STOP_ON_ENTRY_KEY = "stopOnEntry";
    private static final String CFG_LAUNCH_CONSOLE_TYPE_KEY = "console";
    private static final String CFG_LAUNCH_SHORTEN_CMD_TYPE_KEY = "shortenCommandLine";
    private static final String CFG_ATTACH_HOSTNAME_KEY = "hostName";
    private static final String CFG_ATTACH_PORT_KEY = "port";
    private static final String CFG_ATTACH_PROCESS_ID_KEY = "processId";
    private static final String CFG_ATTACH_PROCESS_ID_PICKER_VALUE = "${command:PickJavaProcess}";
    private static final String CFG_ATTACH_TIMEOUT_KEY = "timeout";
    public static final LaunchJsonV0_2_0 INSTANCE = new LaunchJsonV0_2_0();
    private final Map<Enum<?>, String> enumAttributes = new IdentityHashMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();

    private LaunchJsonV0_2_0() {
        this.enumAttributes.put(ConsoleType.INTERNAL_CONSOLE, "internalConsole");
        this.enumAttributes.put(ConsoleType.INTEGRATED_TERMINAL, "integratedTerminal");
        this.enumAttributes.put(ConsoleType.EXTERNAL_TERMINAL, "externalTerminal");
        this.enumAttributes.put(InternalConsoleBehaviour.NEVER_OPEN, "neverOpen");
        this.enumAttributes.put(InternalConsoleBehaviour.OPEN_ON_FIRST_SESSION_START, "openOnFirstSessionStart");
        this.enumAttributes.put(InternalConsoleBehaviour.OPEN_ON_SESSION_START, "openOnSessionStart");
        this.enumAttributes.put(RequestType.ATTACH, "attach");
        this.enumAttributes.put(RequestType.LAUNCH, "launch");
        this.enumAttributes.put(ShortCmdBehaviour.NONE, "none");
        this.enumAttributes.put(ShortCmdBehaviour.JAR_MANIFEST, "jarmanifest");
        this.enumAttributes.put(ShortCmdBehaviour.ARGUMENT_FILE, "argfile");
        this.enumAttributes.put(ShortCmdBehaviour.AUTO, "auto");
    }

    @Override
    public void write(BatchedLaunchWriter data, Path projectRoot) throws IOException {
        try {
            this.write0(data, projectRoot);
        }
        catch (JsonParseException e) {
            throw new IOException("Error while parsing current launch.json", e);
        }
    }

    private void write0(BatchedLaunchWriter data, Path projectRoot) throws IOException {
        JsonObject root;
        Path launchJson = LaunchJsonV0_2_0.resolveLaunchFilePath(projectRoot);
        if (data.getKeepCurrentContent() == WritingMode.MODIFY_CURRENT && Files.exists(launchJson, new LinkOption[0])) {
            try {
                root = new JsonStreamParser(Files.newBufferedReader(launchJson)).next().getAsJsonObject();
            }
            catch (IllegalStateException | NoSuchElementException e) {
                throw new JsonParseException("Malformed launch.json - missing root object", e);
            }
        } else {
            root = new JsonObject();
        }
        this.checkVersion(root);
        JsonArray configs = JsonUtils.getArrayOrSetDefault(root, CONFIGURATIONS_KEY, new JsonArray());
        this.checkGroupRemoval(configs, data.getGroupConfigurations());
        Map<String, JsonObject> existingConfigs = this.getExistingConfigs(configs);
        data.getAllConfigurations().forEach(cfg -> {
            JsonObject cfgObject = (JsonObject)existingConfigs.get(cfg.getName());
            if (cfgObject == null) {
                cfgObject = new JsonObject();
                configs.add(cfgObject);
            }
            this.serializeConfiguration(cfgObject, (JavaConfiguration<?>)cfg, projectRoot);
        });
        Files.createDirectories(launchJson.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(launchJson, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.gson.toJson((JsonElement)root, this.gson.newJsonWriter(writer));
        }
    }

    public static Path resolveLaunchFilePath(Path projectRoot) {
        return projectRoot.resolve(".vscode").resolve("launch.json");
    }

    private Map<String, JsonObject> getExistingConfigs(JsonArray configs) {
        HashMap<String, JsonObject> result = new HashMap<String, JsonObject>();
        for (JsonObject jsonObject : JsonUtils.getObjectsFromArray(configs)) {
            String name = JsonUtils.getStringOrKeep(jsonObject, CFG_NAME_KEY);
            if (name == null) continue;
            result.put(name, jsonObject);
        }
        return result;
    }

    private void checkGroupRemoval(JsonArray configs, List<IWriter.GroupConfiguration> groupConfigurations) {
        HashSet<String> forRemoval = new HashSet<String>();
        for (IWriter.GroupConfiguration groupConfiguration : groupConfigurations) {
            if (groupConfiguration.getWritingMode() == WritingMode.MODIFY_CURRENT) continue;
            forRemoval.add(groupConfiguration.getConfigurationGroup().getName());
        }
        Iterator<JsonElement> it = configs.iterator();
        while (it.hasNext()) {
            JsonObject config;
            JsonObject presentation;
            String presentationGroup;
            JsonElement element = it.next();
            if (!element.isJsonObject() || !forRemoval.contains(presentationGroup = JsonUtils.getStringOrKeep(presentation = JsonUtils.getObjectOrKeep(config = element.getAsJsonObject(), CFG_PRESENTATION_KEY), PRESENTATION_GROUP_KEY))) continue;
            it.remove();
        }
    }

    private void checkVersion(JsonObject root) {
        String version = JsonUtils.getStringOrSetDefault(root, VERSION_KEY, VERSION_VALUE).trim();
        if (!version.isEmpty() && !version.equals(VERSION_VALUE)) {
            throw new JsonParseException("Launch.json version is not 0.2.0");
        }
    }

    private void serializeConfiguration(JsonObject cfgObject, JavaConfiguration<?> cfg, Path workspaceFolder) {
        cfgObject.addProperty(CFG_TYPE_KEY, cfg.getType());
        cfgObject.addProperty(CFG_REQUEST_KEY, this.enumAttributes.get((Object)cfg.getRequestType()));
        cfgObject.addProperty(CFG_NAME_KEY, cfg.getName());
        cfgObject.add(CFG_PRESENTATION_KEY, this.serializePresentation(cfg, JsonUtils.getObjectOrSetDefault(cfgObject, CFG_PRESENTATION_KEY, new JsonObject())));
        this.serializeNullable(cfgObject, CFG_PRE_TASK_KEY, cfg.getPreTaskName());
        this.serializeNullable(cfgObject, CFG_POST_TAKS_KEY, cfg.getPostTaskName());
        this.serializeNullable(cfgObject, CFG_INTERNAL_CONSOLE_BEHAVIOUR_KEY, cfg.getInternalConsoleOptions());
        cfgObject.addProperty(CFG_JAVA_PROJECT_NAME_KEY, cfg.getProjectName());
        this.serializeNullablePaths(cfgObject, CFG_JAVA_SOURCE_PATHS_KEY, cfg.getAdditionalSourcePaths(), workspaceFolder);
        if (cfg instanceof LaunchConfiguration) {
            LaunchConfiguration launchCfg = (LaunchConfiguration)cfg;
            cfgObject.addProperty(CFG_LAUNCH_MAIN_CLASS_KEY, launchCfg.getMainClass());
            this.serializeNullable(cfgObject, CFG_LAUNCH_ARGUMENTS_KEY, launchCfg.getArguments());
            this.serializeNullablePaths(cfgObject, CFG_LAUNCH_MODULE_PATHS_KEY, launchCfg.getModulePathsOverride(), workspaceFolder);
            this.serializeNullablePaths(cfgObject, CFG_LAUNCH_CLASS_PATHS_KEY, launchCfg.getClassPathsOverride(), workspaceFolder);
            this.serializeNullable(cfgObject, CFG_LAUNCH_ENCODING_KEY, launchCfg.getFileEncoding());
            this.serializeNullable(cfgObject, CFG_LAUNCH_VM_ARGUMENTS_KEY, launchCfg.getAdditionalJvmArgs());
            this.serializeNullable(cfgObject, CFG_LAUNCH_WORKING_DIRECTORY_KEY, launchCfg.getCurrentWorkingDirectory(), workspaceFolder);
            this.serializeNullable(cfgObject, CFG_LAUNCH_ENVIRONMENT_PROPS_KEY, launchCfg.getEnvironmentVariables());
            this.serializeNullable(cfgObject, CFG_LAUNCH_ENVIRONMENT_FILE_KEY, launchCfg.getEnvironmentVariablesFile(), workspaceFolder);
            this.serializeNullable(cfgObject, CFG_LAUNCH_STOP_ON_ENTRY_KEY, launchCfg.shouldStopAppEntry());
            this.serializeNullable(cfgObject, CFG_LAUNCH_CONSOLE_TYPE_KEY, launchCfg.getConsoleType());
            this.serializeNullable(cfgObject, CFG_LAUNCH_SHORTEN_CMD_TYPE_KEY, launchCfg.getShortenCommandLine());
        } else if (cfg instanceof AttachConfiguration) {
            AttachConfiguration attachCfg = (AttachConfiguration)cfg;
            cfgObject.addProperty(CFG_ATTACH_HOSTNAME_KEY, attachCfg.getHostName());
            cfgObject.addProperty(CFG_ATTACH_PORT_KEY, attachCfg.getPort());
            this.serializeNullable(cfgObject, CFG_ATTACH_TIMEOUT_KEY, attachCfg.getTimeout());
            if (attachCfg.usesProcessPicker() != null) {
                if (attachCfg.usesProcessPicker().booleanValue()) {
                    cfgObject.addProperty(CFG_ATTACH_PROCESS_ID_KEY, CFG_ATTACH_PROCESS_ID_PICKER_VALUE);
                } else {
                    this.serializeNullable(cfgObject, CFG_ATTACH_PROCESS_ID_KEY, attachCfg.getProcessId());
                }
            }
        }
    }

    private JsonObject serializePresentation(JavaConfiguration<?> cfg, JsonObject currentPresentation) {
        LaunchGroupEntry<?> groupEntry = cfg.getLaunchGroupEntry();
        this.serializeNullable(currentPresentation, PRESENTATION_GROUP_KEY, groupEntry.getGroupName());
        this.serializeNullable(currentPresentation, PRESENTATION_INDEX_KEY, groupEntry.getIndexInGroup());
        this.serializeNullable(currentPresentation, PRESENTATION_VISIBILITY_KEY, groupEntry.isVisibleInGroup());
        return currentPresentation;
    }

    private void serializeNullable(JsonObject object, String key, String value) {
        if (value != null) {
            object.addProperty(key, value);
        }
    }

    private void serializeNullable(JsonObject object, String key, Number value) {
        if (value != null) {
            object.addProperty(key, value);
        }
    }

    private void serializeNullable(JsonObject object, String key, Boolean value) {
        if (value != null) {
            object.addProperty(key, value);
        }
    }

    private void serializeNullable(JsonObject object, String key, Enum<?> value) {
        if (value != null) {
            object.addProperty(key, this.enumAttributes.get(value));
        }
    }

    private void serializeNullable(JsonObject object, String key, Charset value) {
        if (value != null) {
            object.addProperty(key, value.name());
        }
    }

    private void serializeNullable(JsonObject object, String key, PathWritable value, Path workspaceFolder) {
        if (value != null) {
            StringBuilder pathString = new StringBuilder();
            value.write(pathString, workspaceFolder);
            object.addProperty(key, pathString.toString());
        }
    }

    private void serializeNullablePaths(JsonObject object, String key, List<? extends PathWritable> value, Path workspaceFolder) {
        if (value != null) {
            JsonArray array = new JsonArray();
            object.add(key, array);
            value.forEach(path -> {
                if (path != null) {
                    StringBuilder pathString = new StringBuilder();
                    path.write(pathString, workspaceFolder);
                    array.add(pathString.toString());
                }
            });
        }
    }

    private void serializeNullable(JsonObject object, String key, List<?> value) {
        if (value != null) {
            JsonArray array = new JsonArray();
            object.add(key, array);
            value.forEach(obj -> {
                if (obj != null) {
                    array.add(obj.toString());
                }
            });
        }
    }

    private void serializeNullable(JsonObject object, String key, Map<?, ?> value) {
        if (value != null) {
            JsonObject map = new JsonObject();
            object.add(key, map);
            value.forEach((k, v) -> {
                if (k != null && v != null) {
                    map.addProperty(k.toString(), v.toString());
                }
            });
        }
    }
}

