/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute;

import java.io.File;
import java.nio.file.Path;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.PathWritable;

public interface LocatorPathLike
extends PathWritable {
    public static final LocatorPathLike AUTO = new StringPath("$Auto");
    public static final LocatorPathLike RUNTIME = new StringPath("$Runtime");
    public static final LocatorPathLike TEST = new StringPath("$Test");

    public static LocatorPathLike ofAuto() {
        return AUTO;
    }

    public static LocatorPathLike ofRuntime() {
        return RUNTIME;
    }

    public static LocatorPathLike ofTest() {
        return TEST;
    }

    public static LocatorPathLike ofNioExclude(Path exclusionPath) {
        return new NioPathWithPrefix("!", exclusionPath);
    }

    public static LocatorPathLike ofWorkSpaceFolderExclude(Path relativeExclusionPath) {
        return new NioPathWithPrefix("!${workspaceFolder}" + File.separator, relativeExclusionPath);
    }

    public static LocatorPathLike ofNio(Path path) {
        return new NioPath(path);
    }

    public static LocatorPathLike ofWorkSpaceFolder(Path relativePath) {
        return new NioPathWithPrefix("${workspaceFolder}" + File.separator, relativePath);
    }

    public static class NioPathWithPrefix
    extends NioPath {
        private final String prefix;

        private NioPathWithPrefix(String prefix, Path path) {
            super(path);
            this.prefix = prefix;
        }

        @Override
        public void write(StringBuilder sink, Path workspaceFolder) {
            sink.append(this.prefix);
            super.write(sink, workspaceFolder);
        }
    }

    public static class NioPath
    implements LocatorPathLike {
        private final Path path;

        private NioPath(Path path) {
            this.path = path;
        }

        @Override
        public void write(StringBuilder sink, Path workspaceFolder) {
            sink.append(PathWritable.pathToRelativeString(this.path, workspaceFolder));
        }
    }

    public static class StringPath
    implements LocatorPathLike {
        private final String value;

        private StringPath(String value) {
            this.value = value;
        }

        @Override
        public void write(StringBuilder sink, Path workspaceFolder) {
            sink.append(this.value);
        }
    }
}

