/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.function.Consumer;
import net.neoforged.moddevgradle.dsl.DataFileCollection;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import net.neoforged.moddevgradle.tasks.CopyDataFile;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Category;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record DataFileCollections(CollectionWrapper accessTransformers, CollectionWrapper interfaceInjectionData) {
    public static final String CONFIGURATION_ACCESS_TRANSFORMERS = "accessTransformers";
    public static final String CONFIGURATION_INTERFACE_INJECTION_DATA = "interfaceInjectionData";

    public static DataFileCollections create(Project project) {
        CollectionWrapper accessTransformers = DataFileCollections.createCollection(project, CONFIGURATION_ACCESS_TRANSFORMERS, "AccessTransformers to widen visibility of Minecraft classes/fields/methods", "accesstransformer");
        accessTransformers.extension().getFiles().convention(new Object[]{project.provider(() -> {
            ConfigurableFileCollection collection = project.getObjects().fileCollection();
            SourceSet mainSourceSet = (SourceSet)ExtensionUtils.getSourceSets(project).getByName("main");
            for (File resources : mainSourceSet.getResources().getSrcDirs()) {
                File defaultPath = new File(resources, "META-INF/accesstransformer.cfg");
                if (!project.file((Object)defaultPath).exists()) continue;
                return collection.from(new Object[]{defaultPath.getAbsolutePath()});
            }
            return collection;
        })});
        CollectionWrapper interfaceInjectionData = DataFileCollections.createCollection(project, CONFIGURATION_INTERFACE_INJECTION_DATA, "Interface injection data adds extend/implements clauses for interfaces to Minecraft code at development time", "interfaceinjection");
        return new DataFileCollections(accessTransformers, interfaceInjectionData);
    }

    private static CollectionWrapper createCollection(final Project project, String name, String description, final String category) {
        Configuration configuration = (Configuration)project.getConfigurations().create(name, spec -> {
            spec.setDescription(description);
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.attributes(attributes -> attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.CATEGORY_ATTRIBUTE.getType(), category))));
        });
        final Configuration elementsConfiguration = (Configuration)project.getConfigurations().create(name + "Elements", spec -> {
            spec.setDescription("Published data files for " + name);
            spec.setCanBeConsumed(true);
            spec.setCanBeResolved(false);
            spec.attributes(attributes -> attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.CATEGORY_ATTRIBUTE.getType(), category))));
        });
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)project.getComponents().getByName("java");
        java.addVariantsFromConfiguration(elementsConfiguration, variant -> {
            if (variant.getConfigurationVariant().getArtifacts().isEmpty()) {
                variant.skip();
            }
        });
        final String copyTaskName = "copy" + StringUtils.capitalize(name) + "Publications";
        final TaskProvider copyTask = project.getTasks().register(copyTaskName, CopyDataFile.class);
        DependencyFactory depFactory = project.getDependencyFactory();
        Consumer<Object> publishCallback = new Consumer<Object>(){
            ConfigurablePublishArtifact firstArtifact;
            int artifactCount;

            @Override
            public void accept(Object artifactNotation) {
                PublishArtifact dummyArtifact = project.getArtifacts().add(elementsConfiguration.getName(), artifactNotation);
                File artifactFile = dummyArtifact.getFile();
                TaskDependency artifactDependencies = dummyArtifact.getBuildDependencies();
                elementsConfiguration.getArtifacts().remove((Object)dummyArtifact);
                Provider copyOutput = project.getLayout().getBuildDirectory().file(copyTaskName + "/" + this.artifactCount + "-" + artifactFile.getName());
                copyTask.configure(t -> {
                    t.dependsOn(new Object[]{artifactDependencies});
                    t.getInputFiles().add(project.getLayout().file(project.provider(() -> artifactFile)));
                    t.getOutputFiles().add(copyOutput);
                });
                project.getArtifacts().add(elementsConfiguration.getName(), (Object)copyOutput, artifact -> {
                    artifact.builtBy(new Object[]{copyTask});
                    if (this.firstArtifact == null) {
                        this.firstArtifact = artifact;
                        artifact.setClassifier(category);
                        this.artifactCount = 1;
                    } else {
                        if (this.artifactCount == 1) {
                            this.firstArtifact.setClassifier(category + this.artifactCount);
                        }
                        artifact.setClassifier(category + ++this.artifactCount);
                    }
                });
            }
        };
        DataFileCollection extension = (DataFileCollection)project.getObjects().newInstance(DataFileCollection.class, new Object[]{publishCallback});
        configuration.getDependencies().add((Object)depFactory.create((FileCollection)extension.getFiles()));
        return new CollectionWrapper(extension, configuration);
    }

    public record CollectionWrapper(DataFileCollection extension, Configuration configuration) {
    }
}

