/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.legacyforge.internal;

import java.net.URI;
import net.neoforged.moddevgradle.internal.RepositoriesPlugin;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginAware;

public class LegacyRepositoriesPlugin
implements Plugin<PluginAware> {
    public void apply(PluginAware target) {
        target.getPluginManager().apply(RepositoriesPlugin.class);
        if (target instanceof Project) {
            Project project = (Project)target;
            this.applyRepositories(project.getRepositories());
        } else if (target instanceof Settings) {
            Settings settings = (Settings)target;
            this.applyRepositories(settings.getDependencyResolutionManagement().getRepositories());
            settings.getGradle().getPlugins().apply(this.getClass());
        } else if (target instanceof Gradle) {
            Gradle gradle = (Gradle)target;
        } else {
            throw new GradleException("This plugin does not support being applied to " + String.valueOf(target));
        }
    }

    private void applyRepositories(RepositoryHandler repositories) {
        repositories.maven(repo -> {
            repo.setName("MinecraftForge");
            repo.setUrl(URI.create("https://maven.minecraftforge.net/"));
        });
    }
}

