/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.impl;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.util.IteratorUtil;

public class BaseTokenFilter<T extends GenericToken<T>>
implements TokenManager<T> {
    private final TokenManager<T> tokenManager;
    private final LinkedList<T> unprocessedTokens;
    private final Iterable<T> remainingTokens;
    private boolean discardingSuppressing;
    private T currentToken;

    public BaseTokenFilter(TokenManager<T> tokenManager) {
        this.tokenManager = tokenManager;
        this.unprocessedTokens = new LinkedList();
        this.remainingTokens = new RemainingTokens();
    }

    @Override
    public final T getNextToken() {
        this.currentToken = null;
        this.currentToken = !this.unprocessedTokens.isEmpty() ? (GenericToken)this.unprocessedTokens.poll() : this.tokenManager.getNextToken();
        while (!this.shouldStopProcessing(this.currentToken)) {
            this.analyzeToken(this.currentToken);
            this.analyzeTokens(this.currentToken, this.remainingTokens);
            this.processCPDSuppression(this.currentToken);
            if (!this.isDiscarding()) {
                return this.currentToken;
            }
            if (!this.unprocessedTokens.isEmpty()) {
                this.currentToken = (GenericToken)this.unprocessedTokens.poll();
                continue;
            }
            this.currentToken = this.tokenManager.getNextToken();
        }
        return null;
    }

    private boolean isDiscarding() {
        return this.discardingSuppressing || this.isLanguageSpecificDiscarding();
    }

    private void processCPDSuppression(T currentToken) {
        for (Object comment = currentToken.getPreviousComment(); comment != null; comment = comment.getPreviousComment()) {
            if (comment.getImage().contains("CPD-OFF")) {
                this.discardingSuppressing = true;
                break;
            }
            if (!comment.getImage().contains("CPD-ON")) continue;
            this.discardingSuppressing = false;
            break;
        }
    }

    protected void analyzeToken(T currentToken) {
    }

    protected void analyzeTokens(T currentToken, Iterable<T> remainingTokens) {
    }

    protected boolean isLanguageSpecificDiscarding() {
        return false;
    }

    protected boolean shouldStopProcessing(T currentToken) {
        return currentToken.isEof();
    }

    private final class RemainingTokens
    implements Iterable<T> {
        private RemainingTokens() {
        }

        @Override
        public Iterator<T> iterator() {
            return new RemainingTokensIterator(this, BaseTokenFilter.this.currentToken);
        }

        private static class RemainingTokensIterator
        extends IteratorUtil.AbstractIterator<T>
        implements Iterator<T> {
            int index = 0;
            T startToken;
            final /* synthetic */ RemainingTokens this$1;

            RemainingTokensIterator(T startToken) {
                this.this$1 = var1_1;
                this.startToken = startToken;
            }

            @Override
            protected void computeNext() {
                assert (this.index >= 0);
                if (this.startToken != this.this$1.BaseTokenFilter.this.currentToken) {
                    throw new ConcurrentModificationException("Using iterator after next token has been requested.");
                }
                if (this.index < this.this$1.BaseTokenFilter.this.unprocessedTokens.size()) {
                    this.setNext((GenericToken)this.this$1.BaseTokenFilter.this.unprocessedTokens.get(this.index++));
                } else {
                    Object nextToken = this.this$1.BaseTokenFilter.this.tokenManager.getNextToken();
                    if (this.this$1.BaseTokenFilter.this.shouldStopProcessing(nextToken)) {
                        this.done();
                        return;
                    }
                    ++this.index;
                    this.this$1.BaseTokenFilter.this.unprocessedTokens.add(nextToken);
                    this.setNext(nextToken);
                }
            }
        }
    }
}

