/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.Closeable;
import java.io.IOException;

public abstract class BaseCloseable
implements Closeable {
    protected boolean open = true;

    protected final void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Closed " + this);
        }
    }

    protected final void ensureOpenIllegalState() throws IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException("Closed " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.open) {
            BaseCloseable baseCloseable = this;
            synchronized (baseCloseable) {
                if (this.open) {
                    this.open = false;
                    this.doClose();
                }
            }
        }
    }

    protected abstract void doClose() throws IOException;
}

