/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface NodeStream<@NonNull T extends Node>
extends Iterable<T> {
    public <R extends Node> NodeStream<R> flatMap(Function<? super T, ? extends @Nullable NodeStream<? extends R>> var1);

    public <R extends Node> NodeStream<R> map(Function<? super T, ? extends @Nullable R> var1);

    public NodeStream<T> filter(Predicate<? super @NonNull T> var1);

    public NodeStream<T> peek(Consumer<? super @NonNull T> var1);

    public NodeStream<T> append(NodeStream<? extends T> var1);

    public NodeStream<T> prepend(NodeStream<? extends T> var1);

    public NodeStream<T> cached();

    public NodeStream<T> take(int var1);

    public NodeStream<T> drop(int var1);

    public NodeStream<T> dropLast(int var1);

    public NodeStream<T> takeWhile(Predicate<? super T> var1);

    public NodeStream<T> distinct();

    default public NodeStream<Node> ancestors() {
        return this.flatMap(Node::ancestors);
    }

    default public NodeStream<Node> ancestorsOrSelf() {
        return this.flatMap(Node::ancestorsOrSelf);
    }

    default public NodeStream<Node> parents() {
        return this.map(Node::getParent);
    }

    default public NodeStream<Node> children() {
        return this.flatMap(Node::children);
    }

    public DescendantNodeStream<Node> descendants();

    public DescendantNodeStream<Node> descendantsOrSelf();

    default public NodeStream<Node> followingSiblings() {
        return this.flatMap(StreamImpl::followingSiblings);
    }

    default public NodeStream<Node> precedingSiblings() {
        return this.flatMap(StreamImpl::precedingSiblings);
    }

    default public <R extends Node> NodeStream<R> children(Class<? extends R> rClass) {
        return this.flatMap(it -> it.children(rClass));
    }

    default public <R extends Node> NodeStream<R> firstChild(Class<? extends R> rClass) {
        return this.flatMap(it -> it.children(rClass).take(1));
    }

    public <R extends Node> DescendantNodeStream<R> descendants(Class<? extends R> var1);

    default public <R extends Node> NodeStream<R> ancestors(Class<? extends R> rClass) {
        return this.flatMap(it -> it.ancestors(rClass));
    }

    default public NodeStream<T> filterNot(Predicate<? super @NonNull T> predicate) {
        return this.filter(predicate.negate());
    }

    default public <U> NodeStream<T> filterMatching(Function<? super @NonNull T, ? extends @Nullable U> extractor, U comparand) {
        return this.filter(t -> Objects.equals(extractor.apply(t), comparand));
    }

    default public <R extends Node> NodeStream<R> filterIs(Class<? extends R> rClass) {
        return this.filter(rClass::isInstance);
    }

    default public <U> NodeStream<T> filterNotMatching(Function<? super @NonNull T, ? extends @Nullable U> extractor, U comparand) {
        return this.filter(t -> !Objects.equals(extractor.apply(t), comparand));
    }

    @Override
    public void forEach(Consumer<? super @NonNull T> var1);

    default public <R> R reduce(R identity, BiFunction<? super R, ? super T, ? extends R> accumulate) {
        R result = identity;
        for (Node node : this) {
            result = accumulate.apply(result, node);
        }
        return result;
    }

    default public int sumBy(ToIntFunction<? super T> toInt) {
        int result = 0;
        for (Node node : this) {
            result += toInt.applyAsInt(node);
        }
        return result;
    }

    public int count();

    default public int sumByInt(ToIntFunction<? super T> intMapper) {
        int sum = 0;
        for (Node item : this) {
            sum += intMapper.applyAsInt(item);
        }
        return sum;
    }

    public boolean nonEmpty();

    default public boolean isEmpty() {
        return !this.nonEmpty();
    }

    public boolean any(Predicate<? super T> var1);

    public boolean none(Predicate<? super T> var1);

    public boolean all(Predicate<? super T> var1);

    default public @Nullable T get(int n) {
        return this.drop(n).first();
    }

    public @Nullable T first();

    default public @NonNull T firstOrThrow() {
        T first = this.first();
        if (first == null) {
            throw new NoSuchElementException("Empty node stream");
        }
        return first;
    }

    default public Optional<T> firstOpt() {
        return Optional.ofNullable(this.first());
    }

    default public @Nullable T first(Predicate<? super T> predicate) {
        return this.filter(predicate).first();
    }

    default public <R extends Node> @Nullable R first(Class<? extends R> rClass) {
        return this.filterIs(rClass).first();
    }

    default public <R extends Node> @Nullable R firstNonNull(Function<? super @NonNull T, ? extends @Nullable R> nullableFun) {
        return this.map(nullableFun).first();
    }

    public @Nullable T last();

    default public <R extends Node> @Nullable R last(Class<? extends R> rClass) {
        return this.filterIs(rClass).last();
    }

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public Stream<@NonNull T> toStream();

    default public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    default public <R> List<R> toList(Function<? super T, ? extends R> mapper) {
        return this.collect(Collectors.mapping(mapper, Collectors.toList()));
    }

    public static <T extends Node> NodeStream<T> of(@Nullable T node) {
        return node == null ? NodeStream.empty() : StreamImpl.singleton(node);
    }

    public static <T extends Node> NodeStream<T> fromIterable(Iterable<? extends @Nullable T> iterable) {
        return StreamImpl.fromIterable(iterable);
    }

    public static <T extends Node> NodeStream<T> ofOptional(Optional<? extends T> optNode) {
        return optNode.map(StreamImpl::singleton).orElseGet(StreamImpl::empty);
    }

    @SafeVarargs
    public static <T extends Node> NodeStream<T> of(T ... nodes) {
        return NodeStream.fromIterable(Arrays.asList(nodes));
    }

    @SafeVarargs
    public static <T extends Node> NodeStream<T> union(NodeStream<? extends T> ... streams) {
        return NodeStream.union(Arrays.asList(streams));
    }

    public static <T extends Node> NodeStream<T> union(Iterable<? extends NodeStream<? extends T>> streams) {
        return StreamImpl.union(streams);
    }

    public static <T extends Node> NodeStream<T> empty() {
        return StreamImpl.empty();
    }

    @SafeVarargs
    public static <T extends Node, R extends Node> NodeStream<R> forkJoin(NodeStream<? extends T> upstream, Function<? super @NonNull T, ? extends NodeStream<? extends R>> fst, Function<? super @NonNull T, ? extends NodeStream<? extends R>> snd, Function<? super T, ? extends NodeStream<? extends R>> ... rest) {
        Objects.requireNonNull(fst);
        Objects.requireNonNull(snd);
        ArrayList mappers = new ArrayList(rest.length + 2);
        mappers.add(fst);
        mappers.add(snd);
        mappers.addAll(Arrays.asList(rest));
        Function<Node, NodeStream> aggregate = t -> NodeStream.union(mappers.stream().map(f -> (NodeStream)f.apply(t)).collect(Collectors.toList()));
        return upstream.cached().flatMap(aggregate);
    }

    @SafeVarargs
    public static <O> Function<@Nullable Object, @Nullable O> asInstanceOf(Class<? extends O> c1, Class<? extends O> ... rest) {
        if (rest.length == 0) {
            return obj -> c1.isInstance(obj) ? obj : null;
        }
        return obj -> {
            if (c1.isInstance(obj)) {
                return obj;
            }
            for (Class aClass : rest) {
                if (!aClass.isInstance(obj)) continue;
                return obj;
            }
            return null;
        };
    }

    public static interface DescendantNodeStream<T extends Node>
    extends NodeStream<T> {
        public DescendantNodeStream<T> crossFindBoundaries(boolean var1);

        default public DescendantNodeStream<T> crossFindBoundaries() {
            return this.crossFindBoundaries(true);
        }
    }
}

