/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.internal.Filtermap;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TraversalUtils {
    private TraversalUtils() {
    }

    static <T extends Node> T getFirstParentOrSelfMatching(Node node, Filtermap<? super Node, ? extends T> filter) {
        for (Node n = node; n != null; n = n.getParent()) {
            Node t = (Node)filter.apply(n);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    static <T extends Node> T getFirstChildMatching(Node node, Filtermap<? super Node, ? extends T> filter, int from, int len) {
        int last = from + len;
        for (int i = from; i < last; ++i) {
            Node c = node.getChild(i);
            Node t = (Node)filter.apply(c);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    static <T extends Node> T getLastChildMatching(Node node, Filtermap<? super Node, ? extends T> filter, int from, int len) {
        for (int i = from + len - 1; i >= from; --i) {
            Node c = node.getChild(i);
            Node t = (Node)filter.apply(c);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    static <T> List<T> findChildrenMatching(Node node, Filtermap<? super Node, ? extends T> filter, int from, int len) {
        return TraversalUtils.findChildrenMatching(node, filter, from, len, Integer.MAX_VALUE);
    }

    static <T> List<T> findChildrenMatching(Node node, Filtermap<? super Node, ? extends T> filter, int from, int len, int maxSize) {
        if (maxSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        int last = from + len;
        for (int i = from; i < last; ++i) {
            Node c = node.getChild(i);
            T t = filter.apply(c);
            if (t == null) continue;
            list.add(t);
            if (list.size() < maxSize) continue;
            return list;
        }
        return list;
    }

    static <T extends Node> int countChildrenMatching(Node node, Filtermap<Node, T> filter, int from, int len) {
        int sum = 0;
        int last = from + len;
        for (int i = from; i < last; ++i) {
            Node c = node.getChild(i);
            Node t = (Node)filter.apply(c);
            if (t == null) continue;
            ++sum;
        }
        return sum;
    }

    static Iterator<Node> childrenIterator(final Node parent, final int from, final int to) {
        assert (parent != null) : "parent should not be null";
        assert (from >= 0 && from <= parent.getNumChildren()) : "'from' should be a valid index";
        assert (to >= 0 && to <= parent.getNumChildren()) : "'to' should be a valid index";
        assert (from <= to) : "'from' should be lower than 'to'";
        if (to == from) {
            return Collections.emptyIterator();
        }
        return new Iterator<Node>(){
            private int i;
            {
                this.i = from;
            }

            @Override
            public boolean hasNext() {
                return this.i < to;
            }

            @Override
            public @NonNull Node next() {
                return parent.getChild(this.i++);
            }
        };
    }
}

