/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.io.Reader;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextFileContent;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

class ReaderTextFile
implements TextFile {
    private final FileId fileId;
    private final LanguageVersion languageVersion;
    private final Reader reader;

    ReaderTextFile(Reader reader, @NonNull FileId fileId, LanguageVersion languageVersion) {
        AssertionUtil.requireParamNotNull("reader", reader);
        AssertionUtil.requireParamNotNull("path id", fileId);
        AssertionUtil.requireParamNotNull("language version", languageVersion);
        this.reader = reader;
        this.languageVersion = languageVersion;
        this.fileId = fileId;
    }

    @Override
    public FileId getFileId() {
        return this.fileId;
    }

    @Override
    public @NonNull LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public TextFileContent readContents() throws IOException {
        return TextFileContent.fromReader(this.reader);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String toString() {
        return "ReaderTextFile[" + this.fileId.getAbsolutePath() + "]";
    }
}

