/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeprecatedAttrLogger {
    private static final Logger LOG = LoggerFactory.getLogger(Attribute.class);

    public abstract void recordUsageOf(Attribute var1);

    public static DeprecatedAttrLogger create(XPathRule rule) {
        return DeprecatedAttrLogger.doCreate(rule, false);
    }

    public static DeprecatedAttrLogger createForSuppression(Rule rule) {
        return DeprecatedAttrLogger.doCreate(rule, true);
    }

    private static DeprecatedAttrLogger doCreate(Rule rule, boolean isSuppressionQuery) {
        if (LOG.isWarnEnabled()) {
            return new AttrLoggerImpl(rule, isSuppressionQuery);
        }
        return DeprecatedAttrLogger.noop();
    }

    public static DeprecatedAttrLogger createAdHocLogger() {
        if (LOG.isWarnEnabled()) {
            return new AdhocLoggerImpl();
        }
        return DeprecatedAttrLogger.noop();
    }

    public static Noop noop() {
        return Noop.INSTANCE;
    }

    private static String getLoggableAttributeName(Attribute attr) {
        return attr.getParent().getXPathNodeName() + "/@" + attr.getName();
    }

    private static final class AdhocLoggerImpl
    extends DeprecatedAttrLogger {
        private AdhocLoggerImpl() {
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
            String replacement = InternalApiBridge.replacementIfDeprecated(attribute);
            if (replacement != null) {
                String name = DeprecatedAttrLogger.getLoggableAttributeName(attribute);
                String msg = "Use of deprecated attribute '" + name + "' in a findChildNodesWithXPath navigation";
                if (!replacement.isEmpty()) {
                    msg = msg + ", please use " + replacement + " instead";
                }
                LOG.warn(msg, (Throwable)new RuntimeException(msg));
            }
        }
    }

    private static final class AttrLoggerImpl
    extends DeprecatedAttrLogger {
        private final ConcurrentMap<String, Boolean> deprecated = new ConcurrentHashMap<String, Boolean>();
        private final Rule rule;
        private final boolean isSuppressionQuery;

        private AttrLoggerImpl(Rule rule, boolean isSuppressionQuery) {
            this.rule = rule;
            this.isSuppressionQuery = isSuppressionQuery;
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
            String name;
            Boolean b;
            String replacement = InternalApiBridge.replacementIfDeprecated(attribute);
            if (replacement != null && (b = this.deprecated.putIfAbsent(name = DeprecatedAttrLogger.getLoggableAttributeName(attribute), Boolean.TRUE)) == null) {
                String user = this.isSuppressionQuery ? "violationSuppressXPath for rule " + this.ruleToString() : "XPath rule " + this.ruleToString();
                String msg = "Use of deprecated attribute '" + name + "' by " + user;
                if (!replacement.isEmpty()) {
                    msg = msg + ", please use " + replacement + " instead";
                }
                LOG.warn(msg);
            }
        }

        public String ruleToString() {
            String name = "'" + this.rule.getName() + "'";
            if (this.rule.getRuleSetName() != null) {
                name = name + " (in ruleset '" + this.rule.getRuleSetName() + "')";
            }
            return name;
        }
    }

    private static final class Noop
    extends DeprecatedAttrLogger {
        static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void recordUsageOf(Attribute attribute) {
        }
    }
}

