/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers.internal.sarif;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.renderers.internal.sarif.SarifLog;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public class SarifLogBuilder {
    private final List<SarifLog.ReportingDescriptor> rules = new ArrayList<SarifLog.ReportingDescriptor>();
    private final List<SarifLog.Result> results = new ArrayList<SarifLog.Result>();
    private final List<SarifLog.ToolConfigurationNotification> toolConfigurationNotifications = new ArrayList<SarifLog.ToolConfigurationNotification>();
    private final List<SarifLog.ToolExecutionNotification> toolExecutionNotifications = new ArrayList<SarifLog.ToolExecutionNotification>();

    public static SarifLogBuilder sarifLogBuilder() {
        return new SarifLogBuilder();
    }

    public SarifLogBuilder add(RuleViolation violation) {
        SarifLog.ReportingDescriptor ruleDescriptor = this.getReportingDescriptor(violation);
        int ruleIndex = this.rules.indexOf(ruleDescriptor);
        if (ruleIndex == -1) {
            this.rules.add(ruleDescriptor);
            ruleIndex = this.rules.size() - 1;
        }
        SarifLog.Location location = this.getRuleViolationLocation(violation);
        SarifLog.Result result = this.resultFrom(ruleDescriptor, ruleIndex, location, violation.getRule().getPriority());
        this.results.add(result);
        return this;
    }

    public SarifLogBuilder addRunTimeError(Report.ProcessingError error) {
        SarifLog.ArtifactLocation artifactLocation = SarifLog.ArtifactLocation.builder().uri(error.getFileId().getUriString()).build();
        SarifLog.PhysicalLocation physicalLocation = SarifLog.PhysicalLocation.builder().artifactLocation(artifactLocation).build();
        SarifLog.Location location = SarifLog.Location.builder().physicalLocation(physicalLocation).build();
        SarifLog.Message message = SarifLog.Message.builder().text(error.getMsg()).build();
        SarifLog.Exception exception = SarifLog.Exception.builder().message(error.getDetail()).build();
        SarifLog.ToolExecutionNotification toolExecutionNotification = SarifLog.ToolExecutionNotification.builder().locations(Collections.singletonList(location)).message(message).exception(exception).build();
        this.toolExecutionNotifications.add(toolExecutionNotification);
        return this;
    }

    public SarifLogBuilder addConfigurationError(Report.ConfigurationError error) {
        SarifLog.AssociatedRule associatedRule = SarifLog.AssociatedRule.builder().id(error.rule().getName()).build();
        SarifLog.Message message = SarifLog.Message.builder().text(error.issue()).build();
        SarifLog.ToolConfigurationNotification toolConfigurationNotification = SarifLog.ToolConfigurationNotification.builder().associatedRule(associatedRule).message(message).build();
        this.toolConfigurationNotifications.add(toolConfigurationNotification);
        return this;
    }

    public SarifLog build() {
        SarifLog.Component driver = this.getDriverComponent().toBuilder().rules(this.rules).build();
        SarifLog.Tool tool = SarifLog.Tool.builder().driver(driver).build();
        SarifLog.Invocation invocation = SarifLog.Invocation.builder().toolExecutionNotifications(this.toolExecutionNotifications).toolConfigurationNotifications(this.toolConfigurationNotifications).executionSuccessful(this.isExecutionSuccessful()).build();
        SarifLog.Run run = SarifLog.Run.builder().tool(tool).results(this.results).invocations(Collections.singletonList(invocation)).build();
        List<SarifLog.Run> runs = Collections.singletonList(run);
        return SarifLog.builder().runs(runs).build();
    }

    private boolean isExecutionSuccessful() {
        return this.toolExecutionNotifications.isEmpty() && this.toolConfigurationNotifications.isEmpty();
    }

    private SarifLog.Result resultFrom(SarifLog.ReportingDescriptor rule, Integer ruleIndex, SarifLog.Location location, RulePriority rulePriority) {
        SarifLog.Result result = SarifLog.Result.builder().ruleId(rule.getId()).ruleIndex(ruleIndex).level(this.pmdPriorityToSarifSeverityLevel(rulePriority)).build();
        SarifLog.Message message = SarifLog.Message.builder().text(rule.getShortDescription().getText()).build();
        result.setMessage(message);
        result.setLocations(Collections.singletonList(location));
        return result;
    }

    private SarifLog.Location getRuleViolationLocation(RuleViolation rv) {
        SarifLog.ArtifactLocation artifactLocation = SarifLog.ArtifactLocation.builder().uri(rv.getFileId().getUriString()).build();
        SarifLog.Region region = SarifLog.Region.builder().startLine(rv.getBeginLine()).endLine(rv.getEndLine()).startColumn(rv.getBeginColumn()).endColumn(rv.getEndColumn()).build();
        SarifLog.PhysicalLocation physicalLocation = SarifLog.PhysicalLocation.builder().artifactLocation(artifactLocation).region(region).build();
        return SarifLog.Location.builder().physicalLocation(physicalLocation).build();
    }

    private SarifLog.ReportingDescriptor getReportingDescriptor(RuleViolation rv) {
        return SarifLog.ReportingDescriptor.builder().id(rv.getRule().getName()).shortDescription(new SarifLog.MultiformatMessage(rv.getDescription())).fullDescription(new SarifLog.MultiformatMessage(rv.getRule().getDescription())).helpUri(rv.getRule().getExternalInfoUrl()).help(new SarifLog.MultiformatMessage(rv.getRule().getDescription())).properties(this.getRuleProperties(rv)).defaultConfiguration(this.getDefaultConfigForRuleViolation(rv)).build();
    }

    private SarifLog.ReportingConfiguration getDefaultConfigForRuleViolation(RuleViolation rv) {
        return SarifLog.ReportingConfiguration.builder().level(this.pmdPriorityToSarifSeverityLevel(rv.getRule().getPriority())).build();
    }

    private SarifLog.PropertyBag getRuleProperties(RuleViolation rv) {
        return SarifLog.PropertyBag.builder().ruleset(rv.getRule().getRuleSetName()).priority(rv.getRule().getPriority().getPriority()).tags(new HashSet<String>(Arrays.asList(rv.getRule().getRuleSetName()))).build();
    }

    private SarifLog.Component getDriverComponent() {
        return SarifLog.Component.builder().name("PMD").version(PMDVersion.VERSION).informationUri("https://docs.pmd-code.org/latest/").build();
    }

    private String pmdPriorityToSarifSeverityLevel(RulePriority rulePriority) {
        switch (rulePriority) {
            case HIGH: 
            case MEDIUM_HIGH: {
                return "error";
            }
            case MEDIUM: {
                return "warning";
            }
            case MEDIUM_LOW: 
            case LOW: {
                return "note";
            }
        }
        return "none";
    }
}

