/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.reporting.CloseHookFileListener;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeterministicOutputListenerWrapper
implements GlobalAnalysisListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeterministicOutputListenerWrapper.class.getName());
    private final GlobalAnalysisListener listener;
    private final Map<FileId, Integer> filesToIdx = new HashMap<FileId, Integer>();
    private final List<ReportWrapper> reportBuffer = new LinkedList<ReportWrapper>();
    private final Object lock = new Object();
    private int nextToOutput;

    public DeterministicOutputListenerWrapper(GlobalAnalysisListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    @Override
    public ListenerInitializer initializer() {
        return ListenerInitializer.tee(CollectionUtil.listOf(new ListenerInitializer(){

            @Override
            public void setFilesToAnalyze(List<FileId> files) {
                for (int i = 0; i < files.size(); ++i) {
                    DeterministicOutputListenerWrapper.this.filesToIdx.put(files.get(i), i);
                }
            }
        }, this.listener.initializer()));
    }

    @Override
    public FileAnalysisListener startFileAnalysis(final TextFile file) {
        final Integer fileIdx = this.filesToIdx.get(file.getFileId());
        Objects.requireNonNull(fileIdx, "File " + file.getFileId() + " was not declared when starting the analysis");
        return new CloseHookFileListener<Report.ReportBuilderListener>(new Report.ReportBuilderListener()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doClose(Report.ReportBuilderListener delegate, @Nullable Exception ignored) throws Exception {
                Report result = (Report)delegate.getResult();
                ReportWrapper wrapper = new ReportWrapper(result, file, fileIdx);
                Object object = DeterministicOutputListenerWrapper.this.lock;
                synchronized (object) {
                    if (fileIdx == DeterministicOutputListenerWrapper.this.nextToOutput) {
                        DeterministicOutputListenerWrapper.this.outputReport(wrapper);
                        DeterministicOutputListenerWrapper.this.nextToOutput++;
                        DeterministicOutputListenerWrapper.this.tryToFlushBuffer();
                    } else {
                        ListIterator<ReportWrapper> iter = DeterministicOutputListenerWrapper.this.reportBuffer.listIterator();
                        while (iter.hasNext()) {
                            ReportWrapper w = (ReportWrapper)iter.next();
                            if (w.compareTo(wrapper) <= 0) continue;
                            iter.previous();
                            break;
                        }
                        iter.add(wrapper);
                    }
                }
            }
        };
    }

    private void tryToFlushBuffer() throws Exception {
        ReportWrapper next;
        int lastOutput = this.nextToOutput;
        ListIterator<ReportWrapper> iter = this.reportBuffer.listIterator();
        while (iter.hasNext() && (next = iter.next()).idx == this.nextToOutput) {
            iter.remove();
            this.outputReport(next);
            ++this.nextToOutput;
        }
        int numOutput = this.nextToOutput - lastOutput;
        if (numOutput > 0) {
            LOG.trace("Flushed {} out of {} buffered reports", (Object)numOutput, (Object)(this.reportBuffer.size() + numOutput));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.tryToFlushBuffer();
            if (!this.reportBuffer.isEmpty()) {
                throw new AssertionError((Object)"Closed listener but not all files have been processed");
            }
        }
        this.listener.close();
    }

    @Override
    public void onConfigError(Report.ConfigurationError error) {
        this.listener.onConfigError(error);
    }

    private void outputReport(ReportWrapper wrapper) throws Exception {
        Report report = wrapper.report;
        try (FileAnalysisListener fileListener = this.listener.startFileAnalysis(wrapper.textFile);){
            for (RuleViolation v : report.getViolations()) {
                fileListener.onRuleViolation(v);
            }
            for (Report.SuppressedViolation sv : report.getSuppressedViolations()) {
                fileListener.onSuppressedRuleViolation(sv);
            }
            for (Report.ProcessingError error : report.getProcessingErrors()) {
                fileListener.onError(error);
            }
        }
    }

    public String toString() {
        return "DeterministicOutputListenerWrapper [listener=" + this.listener + ", bufferSize=" + this.reportBuffer.size() + "]";
    }

    private static final class ReportWrapper
    implements Comparable<ReportWrapper> {
        private final Report report;
        private final TextFile textFile;
        private final int idx;

        ReportWrapper(Report report, TextFile textFile, int idx) {
            this.report = report;
            this.textFile = textFile;
            this.idx = idx;
        }

        @Override
        public int compareTo(ReportWrapper o) {
            return Integer.compare(this.idx, o.idx);
        }
    }
}

