/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.benchmark.TimingReport;

public final class TimeTracker {
    private static boolean trackTime = false;
    private static long wallClockStartMillis = -1L;
    private static final ThreadLocal<Queue<TimerEntry>> TIMER_ENTRIES;
    private static final ConcurrentMap<TimedOperationKey, TimedResult> ACCUMULATED_RESULTS;
    private static final TimedOperation NOOP_TIMED_OPERATION;

    private TimeTracker() {
        throw new AssertionError((Object)"Can't instantiate utility class");
    }

    public static void startGlobalTracking() {
        wallClockStartMillis = System.currentTimeMillis();
        trackTime = true;
        ACCUMULATED_RESULTS.clear();
        TimeTracker.initThread();
    }

    public static TimingReport stopGlobalTracking() {
        if (!trackTime) {
            return null;
        }
        TimeTracker.finishThread();
        trackTime = false;
        TimedResult unaccountedResult = (TimedResult)ACCUMULATED_RESULTS.get(new TimedOperationKey(TimedOperationCategory.UNACCOUNTED, null));
        unaccountedResult.totalTimeNanos.set(unaccountedResult.selfTimeNanos.get());
        unaccountedResult.callCount.set(0);
        return new TimingReport(System.currentTimeMillis() - wallClockStartMillis, ACCUMULATED_RESULTS);
    }

    public static void initThread() {
        if (!trackTime) {
            return;
        }
        TimeTracker.startOperation(TimedOperationCategory.UNACCOUNTED);
    }

    public static void finishThread() {
        if (!trackTime) {
            return;
        }
        TimeTracker.finishOperation(0L);
        if (TIMER_ENTRIES.get().isEmpty()) {
            TIMER_ENTRIES.remove();
        }
    }

    public static TimedOperation startOperation(TimedOperationCategory category) {
        return TimeTracker.startOperation(category, null);
    }

    public static TimedOperation startOperation(TimedOperationCategory category, String label) {
        if (!trackTime) {
            return NOOP_TIMED_OPERATION;
        }
        TIMER_ENTRIES.get().add(new TimerEntry(category, label));
        return new TimedOperationImpl();
    }

    static void finishOperation(long extraDataCounter) {
        if (!trackTime) {
            return;
        }
        Queue<TimerEntry> queue = TIMER_ENTRIES.get();
        TimerEntry timerEntry = queue.remove();
        TimedResult result = (TimedResult)ACCUMULATED_RESULTS.get(timerEntry.operation);
        if (result == null) {
            ACCUMULATED_RESULTS.putIfAbsent(timerEntry.operation, new TimedResult());
            result = (TimedResult)ACCUMULATED_RESULTS.get(timerEntry.operation);
        }
        long delta = result.accumulate(timerEntry, extraDataCounter);
        if (!queue.isEmpty()) {
            queue.peek().inNestedOperationsNanos += delta;
        }
    }

    public static void bench(String label, Runnable runnable) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.LANGUAGE_SPECIFIC_PROCESSING, label);){
            runnable.run();
        }
    }

    public static <T> T bench(String label, Supplier<T> runnable) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.LANGUAGE_SPECIFIC_PROCESSING, label);){
            T t = runnable.get();
            return t;
        }
    }

    static {
        ACCUMULATED_RESULTS = new ConcurrentHashMap<TimedOperationKey, TimedResult>();
        NOOP_TIMED_OPERATION = new TimedOperation(){

            @Override
            public void close() {
            }

            @Override
            public void close(int count) {
            }
        };
        TIMER_ENTRIES = ThreadLocal.withInitial(() -> Collections.asLifoQueue(new LinkedList()));
    }

    static class TimedOperationKey {
        final TimedOperationCategory category;
        final String label;

        TimedOperationKey(TimedOperationCategory category, String label) {
            this.category = category;
            this.label = label;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimedOperationKey other = (TimedOperationKey)obj;
            return this.category == other.category && Objects.equals(this.label, other.label);
        }

        public String toString() {
            return "TimedOperationKey [category=" + (Object)((Object)this.category) + ", label=" + this.label + "]";
        }
    }

    static class TimedResult {
        AtomicLong totalTimeNanos = new AtomicLong();
        AtomicLong selfTimeNanos = new AtomicLong();
        AtomicInteger callCount = new AtomicInteger();
        AtomicLong extraDataCounter = new AtomicLong();

        TimedResult() {
        }

        long accumulate(TimerEntry timerEntry, long extraData) {
            long delta = System.nanoTime() - timerEntry.start;
            this.totalTimeNanos.getAndAdd(delta);
            this.selfTimeNanos.getAndAdd(delta - timerEntry.inNestedOperationsNanos);
            this.callCount.getAndIncrement();
            this.extraDataCounter.getAndAdd(extraData);
            return delta;
        }

        void mergeTimes(TimedResult timedResult) {
            this.totalTimeNanos.getAndAdd(timedResult.totalTimeNanos.get());
            this.selfTimeNanos.getAndAdd(timedResult.selfTimeNanos.get());
        }
    }

    private static class TimerEntry {
        final TimedOperationKey operation;
        final long start;
        long inNestedOperationsNanos = 0L;

        TimerEntry(TimedOperationCategory category, String label) {
            this.operation = new TimedOperationKey(category, label);
            this.start = System.nanoTime();
        }

        public String toString() {
            return "TimerEntry for " + this.operation;
        }
    }

    private static final class TimedOperationImpl
    implements TimedOperation {
        private boolean closed = false;

        private TimedOperationImpl() {
        }

        @Override
        public void close() {
            this.close(0);
        }

        @Override
        public void close(int extraDataCounter) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TimeTracker.finishOperation(extraDataCounter);
        }
    }
}

