/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.oowekyala.ooxml.DomUtils;
import com.github.oowekyala.ooxml.messages.XmlException;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.properties.ConstraintViolatedException;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyTypeId;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.internal.ResourceLoader;
import net.sourceforge.pmd.util.internal.xml.PmdXmlReporter;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import net.sourceforge.pmd.util.internal.xml.XmlUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RuleFactory {
    private final ResourceLoader resourceLoader;
    private final LanguageRegistry languageRegistry;

    RuleFactory(ResourceLoader resourceLoader, LanguageRegistry languageRegistry) {
        this.resourceLoader = resourceLoader;
        this.languageRegistry = languageRegistry;
    }

    public RuleReference decorateRule(Rule referencedRule, RuleSetReference ruleSetReference, Element ruleElement, PmdXmlReporter err) {
        RuleReference ruleReference = new RuleReference(referencedRule, ruleSetReference);
        SchemaConstants.DEPRECATED.getAttributeOpt(ruleElement).map(Boolean::parseBoolean).ifPresent(ruleReference::setDeprecated);
        SchemaConstants.NAME.getAttributeOpt(ruleElement).ifPresent(ruleReference::setName);
        SchemaConstants.MESSAGE.getAttributeOpt(ruleElement).ifPresent(ruleReference::setMessage);
        SchemaConstants.EXTERNAL_INFO_URL.getAttributeOpt(ruleElement).ifPresent(ruleReference::setExternalInfoUrl);
        for (Element node : DomUtils.children((Element)ruleElement)) {
            if (SchemaConstants.DESCRIPTION.matchesElt(node)) {
                ruleReference.setDescription(XmlUtil.parseTextNode(node));
                continue;
            }
            if (SchemaConstants.EXAMPLE.matchesElt(node)) {
                ruleReference.addExample(XmlUtil.parseTextNode(node));
                continue;
            }
            if (SchemaConstants.PRIORITY.matchesElt(node)) {
                RulePriority priority = RuleFactory.parsePriority(err, node);
                if (priority == null) {
                    priority = RulePriority.MEDIUM;
                }
                ruleReference.setPriority(priority);
                continue;
            }
            if (SchemaConstants.PROPERTIES.matchesElt(node)) {
                this.setPropertyValues(ruleReference, node, err);
                continue;
            }
            ((PmdReporter)err.at(node)).error("Unexpected element ''{0}'' in {1}", node.getTagName(), "rule " + ruleReference.getName());
        }
        return ruleReference;
    }

    public Rule buildRule(Element ruleElement, PmdXmlReporter err) {
        Rule rule;
        try {
            String clazz = SchemaConstants.CLASS.getNonBlankAttribute(ruleElement, err);
            rule = this.resourceLoader.loadRuleFromClassPath(clazz);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Attr node = SchemaConstants.CLASS.getAttributeNode(ruleElement);
            throw ((PmdReporter)err.at(node)).error(e, "Reflection error while instantiating rule ({0})", e.getClass().getSimpleName());
        }
        rule.setName(SchemaConstants.NAME.getNonBlankAttribute(ruleElement, err));
        if (rule.getLanguage() == null) {
            this.setLanguage(ruleElement, err, rule);
        }
        Language language = rule.getLanguage();
        assert (language != null);
        rule.setMinimumLanguageVersion(this.getLanguageVersion(ruleElement, err, language, SchemaConstants.MINIMUM_LANGUAGE_VERSION));
        rule.setMaximumLanguageVersion(this.getLanguageVersion(ruleElement, err, language, SchemaConstants.MAXIMUM_LANGUAGE_VERSION));
        this.checkVersionsAreOrdered(ruleElement, err, rule);
        SchemaConstants.SINCE.getAttributeOpt(ruleElement).ifPresent(rule::setSince);
        SchemaConstants.MESSAGE.getAttributeOpt(ruleElement).ifPresent(rule::setMessage);
        SchemaConstants.EXTERNAL_INFO_URL.getAttributeOpt(ruleElement).ifPresent(rule::setExternalInfoUrl);
        SchemaConstants.DEPRECATED.getAttributeOpt(ruleElement).map(Boolean::parseBoolean).ifPresent(rule::setDeprecated);
        for (Element node : DomUtils.children((Element)ruleElement)) {
            if (SchemaConstants.DESCRIPTION.matchesElt(node)) {
                rule.setDescription(XmlUtil.parseTextNode(node));
                continue;
            }
            if (SchemaConstants.EXAMPLE.matchesElt(node)) {
                rule.addExample(XmlUtil.parseTextNode(node));
                continue;
            }
            if (SchemaConstants.PRIORITY.matchesElt(node)) {
                RulePriority rp = RuleFactory.parsePriority(err, node);
                if (rp == null) {
                    rp = RulePriority.MEDIUM;
                }
                rule.setPriority(rp);
                continue;
            }
            if (SchemaConstants.PROPERTIES.matchesElt(node)) {
                this.parsePropertiesForDefinitions(rule, node, err);
                this.setPropertyValues(rule, node, err);
                continue;
            }
            throw ((PmdReporter)err.at(node)).error("Unexpected element ''{0}'' in {1}", "rule " + SchemaConstants.NAME.getAttributeOrNull(ruleElement));
        }
        return rule;
    }

    private void checkVersionsAreOrdered(Element ruleElement, PmdXmlReporter err, Rule rule) {
        if (rule.getMinimumLanguageVersion() != null && rule.getMaximumLanguageVersion() != null && rule.getMinimumLanguageVersion().compareTo(rule.getMaximumLanguageVersion()) > 0) {
            throw ((PmdReporter)err.at(SchemaConstants.MINIMUM_LANGUAGE_VERSION.getAttributeNode(ruleElement))).error("Invalid language version range, minimum version ''{0}'' is greater than maximum version ''{1}''", rule.getMinimumLanguageVersion(), rule.getMaximumLanguageVersion());
        }
    }

    public static @Nullable RulePriority parsePriority(PmdXmlReporter err, Element node) {
        String text = XmlUtil.parseTextNode(node);
        RulePriority rp = RulePriority.valueOfNullable(text);
        if (rp == null) {
            ((PmdReporter)err.at(node)).error("Not a valid priority: ''{0}'', expected a number in [1,5]", text);
            return null;
        }
        return rp;
    }

    private LanguageVersion getLanguageVersion(Element ruleElement, PmdXmlReporter err, Language language, SchemaConstant attrName) {
        if (attrName.hasAttribute(ruleElement)) {
            String attrValue = attrName.getAttributeOrThrow(ruleElement, err);
            LanguageVersion version = language.getVersion(attrValue);
            if (version == null) {
                String supportedVersions = language.getVersions().stream().map(LanguageVersion::getVersion).filter(it -> !it.isEmpty()).map(StringUtil::inSingleQuotes).collect(Collectors.joining(", "));
                String message = supportedVersions.isEmpty() ? "Invalid language version ''{0}'' for language ''{1}'', the language has no named versions" : "Invalid language version ''{0}'' for language ''{1}'', supported versions are {2}";
                throw ((PmdReporter)err.at(attrName.getAttributeNode(ruleElement))).error(message, attrValue, language.getId(), supportedVersions);
            }
            return version;
        }
        return null;
    }

    private void setLanguage(Element ruleElement, PmdXmlReporter err, Rule rule) {
        String langId = SchemaConstants.LANGUAGE.getNonBlankAttribute(ruleElement, err);
        Language lang = this.languageRegistry.getLanguageById(langId);
        if (lang == null) {
            Attr node = SchemaConstants.LANGUAGE.getAttributeNode(ruleElement);
            throw ((PmdReporter)err.at(node)).error("Invalid language ''{0}'', possible values are {1}", langId, this.supportedLanguages());
        }
        rule.setLanguage(lang);
    }

    private @NonNull String supportedLanguages() {
        return this.languageRegistry.commaSeparatedList(l -> StringUtil.inSingleQuotes(l.getId()));
    }

    private void parsePropertiesForDefinitions(Rule rule, Element propertiesNode, @NonNull PmdXmlReporter err) {
        for (Element child : SchemaConstants.PROPERTY_ELT.getElementChildrenNamedReportOthers(propertiesNode, err)) {
            if (!RuleFactory.isPropertyDefinition(child)) continue;
            rule.definePropertyDescriptor(RuleFactory.parsePropertyDefinition(child, err));
        }
    }

    private void setPropertyValues(Rule rule, Element propertiesElt, PmdXmlReporter err) {
        HashSet<String> overridden = new HashSet<String>();
        XmlException exception = null;
        for (Element element : SchemaConstants.PROPERTY_ELT.getElementChildrenNamedReportOthers(propertiesElt, err)) {
            String name = SchemaConstants.NAME.getAttributeOrThrow(element, err);
            if (!overridden.add(name)) {
                ((PmdReporter)err.at(element)).warn("Duplicate property tag with name ''{0}'', this will be ignored", name);
                continue;
            }
            PropertyDescriptor<?> desc = rule.getPropertyDescriptor(name);
            if (desc == null) {
                throw ((PmdReporter)err.at(element)).error("Cannot set non-existent property ''{0}'' on rule {1}", name, rule.getName());
            }
            try {
                this.setRulePropertyCapture(rule, desc, element, err);
            }
            catch (XmlException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed((Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private <T> void setRulePropertyCapture(Rule rule, PropertyDescriptor<T> descriptor, Element propertyElt, PmdXmlReporter err) {
        T value = RuleFactory.parsePropertyValue(propertyElt, err, descriptor.serializer());
        rule.setProperty(descriptor, value);
    }

    private static boolean isPropertyDefinition(Element node) {
        return SchemaConstants.PROPERTY_TYPE.hasAttribute(node);
    }

    private static PropertyDescriptor<?> parsePropertyDefinition(Element propertyElement, PmdXmlReporter err) {
        String typeId = SchemaConstants.PROPERTY_TYPE.getAttributeOrThrow(propertyElement, err);
        PropertyTypeId factory = PropertyTypeId.lookupMnemonic(typeId);
        if (factory == null) {
            throw ((PmdReporter)err.at(SchemaConstants.PROPERTY_TYPE.getAttributeNode(propertyElement))).error("Unsupported property type ''{0}''", typeId);
        }
        return RuleFactory.propertyDefCapture(propertyElement, err, factory.getBuilderUtils());
    }

    private static <T> PropertyDescriptor<T> propertyDefCapture(Element propertyElement, PmdXmlReporter err, PropertyTypeId.BuilderAndMapper<T> factory) {
        String name = SchemaConstants.NAME.getNonBlankAttributeOrThrow(propertyElement, err);
        String description = SchemaConstants.DESCRIPTION.getNonBlankAttributeOrThrow(propertyElement, err);
        try {
            Object builder = factory.newBuilder(name).desc(description);
            if (SchemaConstants.DELIMITER.hasAttribute(propertyElement)) {
                ((PmdReporter)err.at(SchemaConstants.DELIMITER.getAttributeNode(propertyElement))).warn("Delimiter attribute is not supported anymore, values are always comma-separated.", new Object[0]);
            }
            RuleFactory.parseConstraints(propertyElement, factory, builder, err);
            ((PropertyBuilder)builder).defaultValue(RuleFactory.parsePropertyValue(propertyElement, err, factory.getXmlMapper()));
            return ((PropertyBuilder)builder).build();
        }
        catch (IllegalArgumentException e) {
            throw ((PmdReporter)err.at(propertyElement)).error(e);
        }
    }

    private static <T> void parseConstraints(Element propertyElement, PropertyTypeId.BuilderAndMapper<T> factory, PropertyBuilder<?, T> builder, PmdXmlReporter err) {
        Optional<Comparable<Comparable>> min = RuleFactory.parseIntoComparable(propertyElement, factory, err, SchemaConstants.PROPERTY_MIN);
        Optional<Comparable<T>> max = RuleFactory.parseIntoComparable(propertyElement, factory, err, SchemaConstants.PROPERTY_MAX);
        if (min.isPresent() && max.isPresent()) {
            if (min.get().compareTo(max.get()) > 0) {
                throw ((PmdReporter)err.at(SchemaConstants.PROPERTY_MIN.getAttributeNode(propertyElement))).error("Minimum value should be lower than maximum value", new Object[0]);
            }
            PropertyConstraint<Comparable<T>> constraint = NumericConstraints.inRange(min.get(), max.get());
            builder.require(constraint);
        } else if (min.isPresent() || max.isPresent()) {
            Comparable minOrMax = min.orElse(max.orElse(null));
            PropertyConstraint<Comparable> constraint = min.isPresent() ? NumericConstraints.above(minOrMax) : NumericConstraints.below(minOrMax);
            builder.require(constraint);
        }
    }

    private static <T> Optional<Comparable<T>> parseIntoComparable(Element propertyElement, PropertyTypeId.BuilderAndMapper<T> factory, PmdXmlReporter err, SchemaConstant schemaConstant) {
        return schemaConstant.getAttributeOpt(propertyElement).map(s -> RuleFactory.tryParsePropertyValue(factory, s, (PmdReporter)err.at(schemaConstant.getAttributeNode(propertyElement)))).map(s -> RuleFactory.asComparableOrThrow(s, (PmdReporter)err.at(schemaConstant.getAttributeNode(propertyElement))));
    }

    private static <T> @Nullable T tryParsePropertyValue(PropertyTypeId.BuilderAndMapper<T> factory, String value, PmdReporter err) {
        try {
            return factory.getXmlMapper().fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw err.error(e);
        }
    }

    private static <T> Comparable<T> asComparableOrThrow(T object, PmdReporter err) {
        if (object instanceof Comparable) {
            return (Comparable)object;
        }
        throw err.error("Object is not comparable", new Object[0]);
    }

    private static <T> T parsePropertyValue(Element propertyElt, PmdXmlReporter err, PropertySerializer<T> syntax) {
        Node node;
        String valueStr;
        String valueAttr = SchemaConstants.PROPERTY_VALUE.getAttributeOrNull(propertyElt);
        Element valueChild = SchemaConstants.PROPERTY_VALUE.getOptChildIn(propertyElt, err);
        Attr attrNode = SchemaConstants.PROPERTY_VALUE.getAttributeNode(propertyElt);
        if (valueChild != null) {
            if (valueAttr != null) {
                ((PmdReporter)err.at(attrNode)).warn("Both a ''value'' attribute and a child element are present, the attribute will be ignored", new Object[0]);
            }
            valueStr = valueChild.getTextContent();
            node = valueChild;
        } else if (valueAttr != null) {
            valueStr = valueAttr;
            node = attrNode;
        } else {
            throw ((PmdReporter)err.at(propertyElt)).error("Required child element named ''{0}'' is missing", SchemaConstants.PROPERTY_VALUE.xmlName());
        }
        try {
            return syntax.fromString(valueStr);
        }
        catch (ConstraintViolatedException e) {
            throw ((PmdReporter)err.at(node)).error(e, StringUtil.quoteMessageFormat(e.getMessageWithoutValue()), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw ((PmdReporter)err.at(node)).error(e);
        }
    }
}

