/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.impl;

import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;

@Experimental
public class UnnecessaryPmdSuppressionRule
extends AbstractRule {
    @Override
    public void apply(Node rootNode, RuleContext ctx) {
        assert (rootNode instanceof RootNode);
        LanguageVersionHandler handler = rootNode.getAstInfo().getLanguageProcessor().services();
        List<ViolationSuppressor> suppressors = CollectionUtil.concatView(handler.getExtraViolationSuppressors(), InternalApiBridge.DEFAULT_SUPPRESSORS);
        for (ViolationSuppressor suppressor : suppressors) {
            Set<ViolationSuppressor.UnusedSuppressorNode> unusedSuppressors = suppressor.getUnusedSuppressors((RootNode)rootNode);
            for (ViolationSuppressor.UnusedSuppressorNode unusedSuppressor : unusedSuppressors) {
                ctx.addViolationNoSuppress(unusedSuppressor.getLocation(), rootNode.getAstInfo(), unusedSuppressor.unusedReason(), new Object[0]);
            }
        }
    }
}

