/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.NoopAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.BaseResultProducingCloseable;
import net.sourceforge.pmd.util.CollectionUtil;

public interface GlobalAnalysisListener
extends AutoCloseable {
    default public ListenerInitializer initializer() {
        return ListenerInitializer.noop();
    }

    public FileAnalysisListener startFileAnalysis(TextFile var1);

    @Override
    public void close() throws Exception;

    default public void onConfigError(Report.ConfigurationError error) {
    }

    public static GlobalAnalysisListener noop() {
        return NoopAnalysisListener.INSTANCE;
    }

    public static GlobalAnalysisListener tee(Collection<? extends GlobalAnalysisListener> listeners) {
        final class TeeListener
        implements GlobalAnalysisListener {
            final List<GlobalAnalysisListener> myList;

            TeeListener(List<GlobalAnalysisListener> myList) {
                this.myList = myList;
            }

            @Override
            public ListenerInitializer initializer() {
                return ListenerInitializer.tee(CollectionUtil.map(this.myList, GlobalAnalysisListener::initializer));
            }

            @Override
            public FileAnalysisListener startFileAnalysis(TextFile file) {
                return FileAnalysisListener.tee(CollectionUtil.map(this.myList, it -> it.startFileAnalysis(file)));
            }

            @Override
            public void close() throws Exception {
                Exception composed = IOUtil.closeAll(this.myList);
                if (composed != null) {
                    throw composed;
                }
            }

            public String toString() {
                return "TeeListener{" + this.myList + '}';
            }

            @Override
            public void onConfigError(Report.ConfigurationError error) {
                this.myList.forEach(l -> l.onConfigError(error));
            }
        }
        AssertionUtil.requireParamNotNull("Listeners", listeners);
        AssertionUtil.requireContainsNoNullValue("Listeners", listeners);
        List<GlobalAnalysisListener> myList = listeners.stream().flatMap(l -> l instanceof TeeListener ? ((TeeListener)l).myList.stream() : Stream.of(l)).filter(l -> !(l instanceof NoopAnalysisListener)).collect(CollectionUtil.toUnmodifiableList());
        if (myList.isEmpty()) {
            return GlobalAnalysisListener.noop();
        }
        if (myList.size() == 1) {
            return (GlobalAnalysisListener)myList.iterator().next();
        }
        return new TeeListener(myList);
    }

    public static GlobalAnalysisListener exceptionThrower() {
        class ExceptionThrowingListener
        implements GlobalAnalysisListener {
            ExceptionThrowingListener() {
            }

            @Override
            public FileAnalysisListener startFileAnalysis(TextFile file) {
                final FileId filename = file.getFileId();
                return new FileAnalysisListener(){

                    @Override
                    public void onRuleViolation(RuleViolation violation) {
                    }

                    @Override
                    public void onError(Report.ProcessingError error) throws FileAnalysisException {
                        throw FileAnalysisException.wrap(filename, error.getError().getMessage(), error.getError());
                    }

                    public String toString() {
                        return "ExceptionThrower";
                    }
                };
            }

            @Override
            public void close() {
            }
        }
        return new ExceptionThrowingListener();
    }

    public static final class ViolationCounterListener
    extends BaseResultProducingCloseable<Integer>
    implements GlobalAnalysisListener {
        private final AtomicInteger count = new AtomicInteger();

        @Override
        protected Integer getResultImpl() {
            return this.count.get();
        }

        @Override
        public FileAnalysisListener startFileAnalysis(TextFile file) {
            return violation -> this.count.incrementAndGet();
        }
    }
}

