/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designerbindings;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.util.designerbindings.RelatedNodesSelector;

public interface DesignerBindings {
    public RelatedNodesSelector getRelatedNodesSelector();

    public Collection<AdditionalInfo> getAdditionalInfo(Node var1);

    public Attribute getMainAttribute(Node var1);

    public boolean isExpandedByDefaultInTree(Node var1);

    public TreeIconId getIcon(Node var1);

    public static class DefaultDesignerBindings
    implements DesignerBindings {
        private static final DefaultDesignerBindings INSTANCE = new DefaultDesignerBindings();

        @Override
        public RelatedNodesSelector getRelatedNodesSelector() {
            return null;
        }

        @Override
        public Collection<AdditionalInfo> getAdditionalInfo(Node node) {
            return Collections.emptyList();
        }

        @Override
        public Attribute getMainAttribute(Node node) {
            String image = node.getImage();
            if (image != null) {
                return new Attribute(node, "Image", image);
            }
            return null;
        }

        @Override
        public boolean isExpandedByDefaultInTree(Node node) {
            return true;
        }

        @Override
        public TreeIconId getIcon(Node node) {
            return null;
        }

        public static DefaultDesignerBindings getInstance() {
            return INSTANCE;
        }
    }

    public static enum TreeIconId {
        CLASS,
        METHOD,
        CONSTRUCTOR,
        FIELD,
        VARIABLE;

    }

    public static class AdditionalInfo {
        private final String sortKey;
        private final String display;

        public AdditionalInfo(String sortKey, String display) {
            this.sortKey = sortKey;
            this.display = display;
        }

        public AdditionalInfo(String display) {
            this(display, display);
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public String getDisplayString() {
            return this.display;
        }
    }
}

