/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.symbols.table.internal.JavaResolvers;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BaseInvocMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CtorInvocMirror
extends BaseInvocMirror<ASTConstructorCall>
implements ExprMirror.CtorInvocationMirror {
    CtorInvocMirror(JavaExprMirrors mirrors, ASTConstructorCall call, boolean mustBeStandalone, ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, call, mustBeStandalone, parent, subexprMaker);
    }

    @Override
    public @NonNull JClassType getEnclosingType() {
        if (((ASTConstructorCall)this.myNode).isAnonymousClass()) {
            return ((ASTConstructorCall)this.myNode).getAnonymousClassDeclaration().getTypeMirror();
        }
        return super.getEnclosingType();
    }

    @Override
    public JTypeMirror getStandaloneType() {
        if (this.isDiamond()) {
            return null;
        }
        return this.getNewType();
    }

    @Override
    public void finishStandaloneInference(@NonNull JTypeMirror standaloneType) {
        if (this.mayMutateAst()) {
            this.setCompileTimeDecl(this.getStandaloneCtdecl());
        }
    }

    @Override
    public @NonNull ExprMirror.TypeSpecies getStandaloneSpecies() {
        return ExprMirror.TypeSpecies.REFERENCE;
    }

    @Override
    public @Nullable JTypeMirror unresolvedType() {
        JTypeMirror newT = this.getNewType();
        if (((ASTConstructorCall)this.myNode).usesDiamondTypeArgs()) {
            ASTType explicitType;
            if (((ASTConstructorCall)this.myNode).getParent() instanceof ASTVariableDeclarator && (explicitType = ((ASTVariableDeclarator)((ASTConstructorCall)this.myNode).getParent()).getVarId().getTypeNode()) != null) {
                return explicitType.getTypeMirror();
            }
            if (newT instanceof JClassType) {
                JClassType classt = (JClassType)newT;
                List<JTypeMirror> fakeTypeArgs = Collections.nCopies(classt.getSymbol().getTypeParameterCount(), this.factory.ts.ERROR);
                newT = classt.withTypeArguments(fakeTypeArgs);
            }
        }
        return newT;
    }

    private List<JMethodSig> getVisibleCandidates(@NonNull JTypeMirror newType) {
        if (((ASTConstructorCall)this.myNode).isAnonymousClass()) {
            return newType.isInterface() ? ((ASTConstructorCall)this.myNode).getTypeSystem().OBJECT.getConstructors() : newType.getConstructors();
        }
        return newType.getConstructors();
    }

    @Override
    public Iterable<JMethodSig> getAccessibleCandidates(JTypeMirror newType) {
        List<JMethodSig> visibleCandidates = this.getVisibleCandidates(newType);
        return TypeOps.lazyFilterAccessible(visibleCandidates, this.getEnclosingType().getSymbol());
    }

    @Override
    public @NonNull JTypeMirror getNewType() {
        JTypeMirror typeMirror = ((ASTConstructorCall)this.myNode).getTypeNode().getTypeMirror();
        if (typeMirror instanceof JClassType) {
            JClassType classTypeMirror = (JClassType)typeMirror;
            if (this.isDiamond()) {
                classTypeMirror = classTypeMirror.getGenericTypeDeclaration();
            }
            return classTypeMirror;
        }
        return typeMirror;
    }

    @Override
    public boolean isDiamond() {
        return ((ASTConstructorCall)this.myNode).usesDiamondTypeArgs();
    }

    @Override
    public boolean isAnonymous() {
        return ((ASTConstructorCall)this.myNode).isAnonymousClass();
    }

    static class ExplicitCtorInvocMirror
    extends BaseInvocMirror<ASTExplicitConstructorInvocation>
    implements ExprMirror.CtorInvocationMirror {
        ExplicitCtorInvocMirror(JavaExprMirrors mirrors, ASTExplicitConstructorInvocation call, ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
            super(mirrors, call, false, parent, subexprMaker);
        }

        @Override
        public Iterable<JMethodSig> getAccessibleCandidates(JTypeMirror newType) {
            if (((ASTExplicitConstructorInvocation)this.myNode).isThis()) {
                return this.getEnclosingType().getConstructors();
            }
            return IteratorUtil.mapIterator(newType.getConstructors(), iter -> IteratorUtil.filter((Iterator)iter, ctor -> JavaResolvers.isAccessibleIn(this.getEnclosingType().getSymbol().getNestRoot(), ctor.getSymbol(), true)));
        }

        @Override
        public @NonNull JClassType getNewType() {
            JClassType encl = this.getEnclosingType();
            return ((ASTExplicitConstructorInvocation)this.myNode).isThis() ? encl : encl.getSuperClass();
        }

        @Override
        public @Nullable JTypeMirror unresolvedType() {
            if (((ASTExplicitConstructorInvocation)this.myNode).isThis()) {
                return ((ASTExplicitConstructorInvocation)this.myNode).getEnclosingType().getTypeMirror();
            }
            return ((ASTExplicitConstructorInvocation)this.myNode).getEnclosingType().getTypeMirror().getSuperClass();
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public boolean isDiamond() {
            return false;
        }
    }

    static class EnumCtorInvocMirror
    extends BaseInvocMirror<ASTEnumConstant>
    implements ExprMirror.CtorInvocationMirror {
        EnumCtorInvocMirror(JavaExprMirrors mirrors, ASTEnumConstant call, ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
            super(mirrors, call, false, parent, subexprMaker);
        }

        @Override
        public Iterable<JMethodSig> getAccessibleCandidates(JTypeMirror newType) {
            return newType.getConstructors();
        }

        @Override
        public @NonNull JClassType getNewType() {
            return this.getEnclosingType();
        }

        @Override
        public boolean isAnonymous() {
            return ((ASTEnumConstant)this.myNode).isAnonymousClass();
        }

        @Override
        public boolean isDiamond() {
            return false;
        }

        @Override
        public @Nullable JTypeMirror unresolvedType() {
            return this.getNewType();
        }
    }
}

