/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpressionList;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public class AssignmentInOperandRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> ALLOW_IF_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIf").desc("Allow assignment within the conditional expression of an if statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_SWITCH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowSwitch").desc("Allow assignment within the conditional expression of a switch statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_FOR_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowFor").desc("Allow assignment within the conditional expression of a for statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_WHILE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowWhile").desc("Allow assignment within the conditional expression of a while statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_DO_WHILE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowDoWhile").desc("Allow assignment within the conditional expression of a do-while statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_INCREMENT_DECREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIncrementDecrement").desc("Allow increment or decrement operators within the conditional expression of an if, for, or while statement")).defaultValue((Object)false)).build();

    public AssignmentInOperandRule() {
        super(ASTAssignmentExpression.class, ASTUnaryExpression.class);
        this.definePropertyDescriptor(ALLOW_IF_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_FOR_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_WHILE_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_DO_WHILE_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_SWITCH_DESCRIPTOR);
    }

    public Object visit(ASTAssignmentExpression node, Object data) {
        this.checkAssignment(node, (RuleContext)data);
        return null;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        if (!((Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR)).booleanValue() && !node.getOperator().isPure()) {
            this.checkAssignment(node, (RuleContext)data);
        }
        return null;
    }

    private void checkAssignment(ASTExpression impureExpr, RuleContext ctx) {
        ASTExpression toplevel = JavaAstUtils.getTopLevelExpr(impureExpr);
        JavaNode parent = (JavaNode)toplevel.getParent();
        if (toplevel == impureExpr && (parent instanceof ASTExpressionStatement || parent instanceof ASTStatementExpressionList || parent instanceof ASTLambdaExpression)) {
            return;
        }
        if (parent instanceof ASTIfStatement && (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) != false || parent instanceof ASTWhileStatement && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) != false || parent instanceof ASTDoStatement && (Boolean)this.getProperty(ALLOW_DO_WHILE_DESCRIPTOR) != false || parent instanceof ASTSwitchStatement && (Boolean)this.getProperty(ALLOW_SWITCH_DESCRIPTOR) != false || parent instanceof ASTForStatement && ((ASTForStatement)parent).getCondition() == toplevel && ((Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR)).booleanValue()) {
            return;
        }
        JavaNode firstChild = (JavaNode)impureExpr.getChild(0);
        if (firstChild instanceof ASTVariableAccess) {
            ctx.addViolation((Node)impureExpr, new Object[]{((ASTVariableAccess)firstChild).getName()});
        } else {
            ctx.addViolationWithMessage((Node)impureExpr, "Avoid assignments in operands");
        }
    }

    @Deprecated
    public boolean allowsAllAssignments() {
        return (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_DO_WHILE_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_SWITCH_DESCRIPTOR) != false;
    }
}

