/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class InefficientEmptyStringCheckRule
extends AbstractJavaRulechainRule {
    public InefficientEmptyStringCheckRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    public Object visit(ASTMethodCall call, Object data) {
        if (InefficientEmptyStringCheckRule.isTrimOrStripCall(call.getQualifier()) && (InefficientEmptyStringCheckRule.isLengthZeroCheck(call) || InefficientEmptyStringCheckRule.isIsEmptyOrIsBlankCall(call))) {
            this.asCtx(data).addViolation((Node)call);
        }
        return null;
    }

    private static boolean isLengthZeroCheck(ASTMethodCall call) {
        return "length".equals(call.getMethodName()) && call.getArguments().isEmpty() && JavaRuleUtil.isZeroChecked(call);
    }

    private static boolean isTrimOrStripCall(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            String methodName = call.getMethodName();
            return ("trim".equals(methodName) || "strip".equals(methodName)) && call.getArguments().isEmpty() && TypeTestUtil.isA(String.class, (TypeNode)call.getQualifier());
        }
        return false;
    }

    private static boolean isIsEmptyOrIsBlankCall(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            String methodName = call.getMethodName();
            return ("isEmpty".equals(methodName) || "isBlank".equals(methodName)) && call.getArguments().isEmpty();
        }
        return false;
    }
}

