/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaExpr;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;

public final class ASTAmbiguousName
extends AbstractJavaExpr
implements ASTReferenceType,
ASTPrimaryExpression {
    private boolean wasProcessed = false;

    ASTAmbiguousName(int id) {
        super(id);
    }

    ASTAmbiguousName(String id) {
        super(122);
        this.setImage(id);
    }

    public String getName() {
        return super.getImage();
    }

    boolean wasProcessed() {
        return this.wasProcessed;
    }

    void setProcessed() {
        this.wasProcessed = true;
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    ASTExpression forceExprContext() {
        return this.shrinkOneSegment(ASTVariableAccess::new, ASTFieldAccess::new);
    }

    ASTClassType forceTypeContext() {
        return this.shrinkOneSegment(ASTClassType::new, ASTClassType::new);
    }

    private <T extends AbstractJavaNode> T shrinkOneSegment(Function<ASTAmbiguousName, T> simpleNameHandler, BiFunction<ASTAmbiguousName, String, T> splitNameConsumer) {
        String image = this.getName();
        int lastDotIdx = image.lastIndexOf(46);
        if (lastDotIdx < 0) {
            AbstractJavaNode res = (AbstractJavaNode)simpleNameHandler.apply(this);
            if (res != null) {
                res.copyTextCoordinates(this);
            }
            return (T)res;
        }
        String lastSegment = image.substring(lastDotIdx + 1);
        String remainingAmbiguous = image.substring(0, lastDotIdx);
        AbstractJavaNode res = (AbstractJavaNode)splitNameConsumer.apply(this, lastSegment);
        if (res != null) {
            res.copyTextCoordinates(this);
        }
        this.shiftTokens(0, -2);
        this.setImage(remainingAmbiguous);
        return (T)res;
    }

    void deleteInParent() {
        AbstractJavaNode parent = (AbstractJavaNode)this.getParent();
        parent.removeChildAtIndex(this.getIndexInParent());
    }

    void shrinkOrDeleteInParentSetImage() {
        this.shrinkOneSegment(simpleName -> {
            String simpleNameImage = simpleName.getFirstToken().getImage();
            AbstractJavaNode parent = (AbstractJavaNode)simpleName.getParent();
            if (parent instanceof ASTClassType) {
                ((ASTClassType)parent).setSimpleName(simpleNameImage);
            } else {
                parent.setImage(simpleName.getFirstToken().getImage());
            }
            parent.removeChildAtIndex(simpleName.getIndexInParent());
            return null;
        }, (ambig, simpleName) -> {
            AbstractJavaNode parent = (AbstractJavaNode)ambig.getParent();
            if (parent instanceof ASTClassType) {
                ((ASTClassType)parent).setSimpleName((String)simpleName);
            } else {
                parent.setImage((String)simpleName);
            }
            return null;
        });
    }
}

