/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.AbstractLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTNumericLiteral
extends AbstractLiteral
implements ASTLiteral {
    private boolean isIntegral;
    private boolean is64bits;
    private long longValue;
    private double doubleValue;

    ASTNumericLiteral(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    @Override
    public Chars getLiteralText() {
        return super.getLiteralText();
    }

    @Override
    public @NonNull Number getConstValue() {
        return (Number)super.getConstValue();
    }

    @Override
    protected @NonNull Number buildConstValue() {
        if (this.isIntegral()) {
            if (this.isIntLiteral()) {
                return this.getValueAsInt();
            }
            return this.getValueAsLong();
        }
        if (this.isFloatLiteral()) {
            return Float.valueOf(this.getValueAsFloat());
        }
        return this.getValueAsDouble();
    }

    @Override
    public @NonNull JPrimitiveType getTypeMirror() {
        return (JPrimitiveType)super.getTypeMirror();
    }

    void setIntLiteral() {
        this.isIntegral = true;
    }

    void setFloatLiteral() {
        this.isIntegral = false;
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        Chars image = this.getLiteralText();
        char lastChar = image.charAt(image.length() - 1);
        if (this.isIntegral) {
            this.is64bits = lastChar == 'l' || lastChar == 'L';
            this.longValue = ASTNumericLiteral.parseIntegralValue(image);
            this.doubleValue = this.longValue;
        } else {
            this.is64bits = lastChar != 'f' && lastChar != 'F';
            this.doubleValue = Double.parseDouble(StringUtils.remove((String)image.toString(), (char)'_'));
            this.longValue = (long)this.doubleValue;
        }
    }

    public boolean isIntLiteral() {
        return this.isIntegral && !this.is64bits;
    }

    public boolean isLongLiteral() {
        return this.isIntegral && this.is64bits;
    }

    public boolean isFloatLiteral() {
        return !this.isIntegral && !this.is64bits;
    }

    public boolean isDoubleLiteral() {
        return !this.isIntegral && this.is64bits;
    }

    public boolean isIntegral() {
        return this.isIntegral;
    }

    public int getBase() {
        return ASTNumericLiteral.getBase(this.getLiteralText(), this.isIntegral());
    }

    static int getBase(Chars image, boolean isIntegral) {
        if (image.length() > 1 && image.charAt(0) == '0') {
            switch (image.charAt(1)) {
                case 'X': 
                case 'x': {
                    return 16;
                }
                case 'B': 
                case 'b': {
                    return 2;
                }
            }
            return isIntegral ? 8 : 10;
        }
        return 10;
    }

    public int getValueAsInt() {
        return (int)this.longValue;
    }

    public long getValueAsLong() {
        return this.longValue;
    }

    public float getValueAsFloat() {
        return (float)this.doubleValue;
    }

    public double getValueAsDouble() {
        return this.doubleValue;
    }

    static long parseIntegralValue(Chars image) {
        int base = ASTNumericLiteral.getBase(image, true);
        if (base == 8) {
            image = image.subSequence(1);
        } else if (base != 10) {
            image = image.subSequence(2);
        }
        int length = image.length();
        char lastChar = image.charAt(length - 1);
        if (lastChar == 'l' || lastChar == 'L') {
            --length;
        }
        try {
            String literalImage = image.substring(0, length).replaceAll("_", "");
            return Long.parseUnsignedLong(literalImage, base);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

