/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.Location;

public class SourcePredicates {
    public static DescribedPredicate<JavaClass> areProductionCode() {
        return SourcePredicates.targetCode(ImportOption.Predefined.DO_NOT_INCLUDE_TESTS, "are production code");
    }

    public static DescribedPredicate<JavaClass> areTestCode() {
        return SourcePredicates.targetCode(ImportOption.Predefined.ONLY_INCLUDE_TESTS, "are test code");
    }

    private static DescribedPredicate<JavaClass> targetCode(final ImportOption.Predefined predicates, String description) {
        return new DescribedPredicate<JavaClass>(description, new Object[0]){

            public boolean apply(JavaClass clazz) {
                return (Boolean)clazz.getSource().map(Source::getUri).map(Location::of).map(arg_0 -> ((ImportOption.Predefined)predicates).includes(arg_0)).orElse((Object)false);
            }
        };
    }

    public static DescribedPredicate<JavaClass> areJavaClasses() {
        return new DescribedPredicate<JavaClass>("are Java classes", new Object[0]){

            public boolean apply(JavaClass clazz) {
                return SourcePredicates.isJavaClass(clazz);
            }
        };
    }

    public static boolean isJavaClass(JavaClass clazz) {
        if (!clazz.getSource().isPresent()) {
            return false;
        }
        Source source = (Source)clazz.getSource().get();
        if (!source.getFileName().isPresent()) {
            return false;
        }
        return ((String)source.getFileName().get()).contains(".java");
    }

    private SourcePredicates() {
    }
}

