/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.immutables.value.Value;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$processor$.meta.$AttributeBuilderDescriptor;
import org.immutables.value.internal.$processor$.meta.$AttributeBuilderThirdPartyModel;
import org.immutables.value.internal.$processor$.meta.$ImmutableAttributeBuilderDescriptor;
import org.immutables.value.internal.$processor$.meta.$ImmutableAttributeBuilderReflection;
import org.immutables.value.internal.$processor$.meta.$ImmutableFirstPartyStrategy;
import org.immutables.value.internal.$processor$.meta.$ImmutableThirdPartyAttributeBuilderStrategy;
import org.immutables.value.internal.$processor$.meta.$ModifiableCreator;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

@Value.Immutable(builder=false)
public abstract class $AttributeBuilderReflection {
    private static final Map<String, $AttributeBuilderDescriptor> analyzedReturnTypes = new HashMap<String, $AttributeBuilderDescriptor>();

    private static String cachingKey($ValueAttribute valueAttribute) {
        return valueAttribute.containedTypeElement.getQualifiedName() + Arrays.toString(valueAttribute.containingType.constitution.style().attributeBuilder());
    }

    public static $AttributeBuilderReflection forValueType($ValueAttribute valueAttribute) {
        return $ImmutableAttributeBuilderReflection.of(valueAttribute);
    }

    @Value.Parameter
    abstract $ValueAttribute valueAttribute();

    @Value.Lazy
    List<Strategy> getStrategies() {
        return Arrays.asList($ImmutableFirstPartyStrategy.of(this.valueAttribute()), ThirdPartyAttributeBuilderStrategy.of(this.valueAttribute()));
    }

    @Value.Lazy
    boolean isAttributeBuilder() {
        if (!this.valueAttribute().style().attributeBuilderDetection()) {
            return false;
        }
        if (this.valueAttribute().containedTypeElement == null) {
            return false;
        }
        String cacheKey = $AttributeBuilderReflection.cachingKey(this.valueAttribute());
        if (analyzedReturnTypes.containsKey(cacheKey)) {
            return analyzedReturnTypes.get(cacheKey) != null;
        }
        for (Strategy strategy : this.getStrategies()) {
            if (!strategy.isAttributeBuilder()) continue;
            return true;
        }
        analyzedReturnTypes.put(cacheKey, null);
        return false;
    }

    @Value.Lazy
    $AttributeBuilderDescriptor getAttributeBuilderDescriptor() {
        if (!this.isAttributeBuilder()) {
            throw new IllegalStateException("Should not call getReflectionStrategy unless isAttributeBuilder is true");
        }
        if (this.valueAttribute().containedTypeElement == null) {
            throw new AssertionError();
        }
        String cacheKey = $AttributeBuilderReflection.cachingKey(this.valueAttribute());
        if (analyzedReturnTypes.containsKey(cacheKey)) {
            return $Preconditions.checkNotNull(analyzedReturnTypes.get(cacheKey));
        }
        $AttributeBuilderDescriptor descriptor = this.getReflectionStrategy().getAttributeBuilderDescriptor();
        analyzedReturnTypes.put(cacheKey, descriptor);
        return descriptor;
    }

    @Value.Lazy
    Strategy getReflectionStrategy() {
        for (Strategy strategy : this.getStrategies()) {
            if (!strategy.isAttributeBuilder()) continue;
            return strategy;
        }
        throw new AssertionError((Object)"isAttributeBuilder flip-flopped from true to false.");
    }

    @Value.Immutable(builder=false)
    static abstract class ThirdPartyAttributeBuilderStrategy
    implements Strategy {
        ThirdPartyAttributeBuilderStrategy() {
        }

        @Nullable
        @Value.Parameter
        abstract $AttributeBuilderThirdPartyModel builderModel();

        @Nullable
        @Value.Parameter
        abstract TypeElement attributeValueType();

        @Value.Parameter
        abstract String attributeName();

        @Override
        public boolean isAttributeBuilder() {
            return this.builderModel() != null;
        }

        @Override
        @Nullable
        @Value.Derived
        public $AttributeBuilderDescriptor getAttributeBuilderDescriptor() {
            if (!this.isAttributeBuilder()) {
                return null;
            }
            $AttributeBuilderThirdPartyModel model = this.builderModel();
            ExecutableElement copyMethod = model.copyMethod();
            ExecutableElement builderMethod = model.builderMethod();
            ExecutableElement buildMethod = model.buildMethod();
            TypeElement attributeBuilderType = model.builderType();
            $AttributeBuilderDescriptor.ValueToBuilderTarget target = copyMethod.getKind() == ElementKind.CONSTRUCTOR ? $AttributeBuilderDescriptor.ValueToBuilderTarget.BUILDER_CONSTRUCTOR : (copyMethod.getModifiers().contains((Object)Modifier.STATIC) ? (copyMethod.getEnclosingElement().equals(this.attributeValueType()) ? $AttributeBuilderDescriptor.ValueToBuilderTarget.VALUE_TYPE : $AttributeBuilderDescriptor.ValueToBuilderTarget.BUILDER_TYPE) : (copyMethod.getEnclosingElement().equals(this.attributeValueType()) ? $AttributeBuilderDescriptor.ValueToBuilderTarget.VALUE_INSTANCE : $AttributeBuilderDescriptor.ValueToBuilderTarget.BUILDER_INSTANCE));
            String qualifiedBuilderConstructorMethod = builderMethod.getEnclosingElement().equals(this.attributeValueType()) ? this.attributeValueType().getQualifiedName() + "." + builderMethod.getSimpleName() : (builderMethod.getKind() == ElementKind.CONSTRUCTOR ? "new " + attributeBuilderType.getQualifiedName() : attributeBuilderType.getQualifiedName() + "." + builderMethod.getSimpleName());
            return $ImmutableAttributeBuilderDescriptor.builder().attributeName(this.attributeName()).valueToBuilderTarget(target).valueToBuilderMethod(copyMethod.getSimpleName().toString()).buildMethod(buildMethod.getSimpleName().toString()).qualifiedValueTypeName(this.attributeValueType().getQualifiedName().toString()).qualifiedBuilderTypeName(attributeBuilderType.getQualifiedName().toString()).qualifiedBuilderConstructorMethod(qualifiedBuilderConstructorMethod).build();
        }

        static ThirdPartyAttributeBuilderStrategy of($ValueAttribute valueAttribute) {
            TypeElement attributeValueType = valueAttribute.containedTypeElement;
            if (attributeValueType == null) {
                return $ImmutableThirdPartyAttributeBuilderStrategy.of(null, null, valueAttribute.name());
            }
            HashMap<TypeElement, $ModifiableCreator> partiallyBuiltModels = new HashMap<TypeElement, $ModifiableCreator>();
            for (Element element : attributeValueType.getEnclosedElements()) {
                $AttributeBuilderThirdPartyModel.Creator maybeCompleteModel;
                $ModifiableCreator newBuilderModel = $ModifiableCreator.create();
                if (ThirdPartyAttributeBuilderStrategy.isPossibleBuilderClass(element, valueAttribute)) {
                    (($AttributeBuilderThirdPartyModel.Creator)newBuilderModel).builderType((TypeElement)element);
                } else if (ThirdPartyAttributeBuilderStrategy.isPossibleBuilderMethod(element, true, valueAttribute)) {
                    (($AttributeBuilderThirdPartyModel.Creator)newBuilderModel).builderMethod((ExecutableElement)element);
                } else if (ThirdPartyAttributeBuilderStrategy.isPossibleCopyMethod(valueAttribute, element, true)) {
                    (($AttributeBuilderThirdPartyModel.Creator)newBuilderModel).copyMethod((ExecutableElement)element);
                }
                if (newBuilderModel.findBuilderType() == null) continue;
                if (partiallyBuiltModels.containsKey(newBuilderModel.findBuilderType())) {
                    $AttributeBuilderThirdPartyModel.Creator partiallyBuiltModel = ($AttributeBuilderThirdPartyModel.Creator)partiallyBuiltModels.get(newBuilderModel.findBuilderType());
                    partiallyBuiltModel.mergeFrom(newBuilderModel);
                    maybeCompleteModel = partiallyBuiltModel;
                } else {
                    ThirdPartyAttributeBuilderStrategy.processPossibleBuilder(valueAttribute, newBuilderModel);
                    partiallyBuiltModels.put(newBuilderModel.findBuilderType(), newBuilderModel);
                    maybeCompleteModel = newBuilderModel;
                }
                if (!maybeCompleteModel.complete()) continue;
                return $ImmutableThirdPartyAttributeBuilderStrategy.of(maybeCompleteModel.toImmutable(), valueAttribute.containedTypeElement, valueAttribute.name());
            }
            return $ImmutableThirdPartyAttributeBuilderStrategy.of(null, null, valueAttribute.name());
        }

        private static void processPossibleBuilder($ValueAttribute attribute, $AttributeBuilderThirdPartyModel.Creator builderModel) {
            for (Element element : builderModel.findBuilderType().getEnclosedElements()) {
                if (builderModel.buildMethod() == null && ThirdPartyAttributeBuilderStrategy.isPossibleBuildMethod(attribute, element)) {
                    builderModel.buildMethod((ExecutableElement)element);
                }
                if (builderModel.builderMethod() == null && ThirdPartyAttributeBuilderStrategy.isPossibleBuilderMethod(element, false, attribute)) {
                    builderModel.builderMethod((ExecutableElement)element);
                }
                if (builderModel.copyMethod() != null || !ThirdPartyAttributeBuilderStrategy.isPossibleCopyMethod(attribute, element, false)) continue;
                builderModel.copyMethod((ExecutableElement)element);
            }
        }

        private static boolean isPossibleBuildMethod($ValueAttribute attribute, Element possibleBuildMethod) {
            if (possibleBuildMethod.getKind() != ElementKind.METHOD) {
                return false;
            }
            if (!attribute.containingType.names().possibleAttributeBuilder(possibleBuildMethod.getSimpleName())) {
                return false;
            }
            Types typeUtils = attribute.containingType.constitution.protoclass().environment().processing().getTypeUtils();
            ExecutableElement candidateBuildMethod = (ExecutableElement)possibleBuildMethod;
            return !candidateBuildMethod.getModifiers().contains((Object)Modifier.STATIC) && candidateBuildMethod.getModifiers().contains((Object)Modifier.PUBLIC) && candidateBuildMethod.getTypeParameters().isEmpty() && candidateBuildMethod.getReturnType().getKind() == TypeKind.DECLARED && typeUtils.isSameType(candidateBuildMethod.getReturnType(), attribute.containedTypeElement.asType());
        }

        private static boolean isPossibleBuilderMethod(Element possibleBuilderMethod, boolean onValueType, $ValueAttribute valueAttribute) {
            if (possibleBuilderMethod.getKind() == ElementKind.METHOD) {
                if (!valueAttribute.containingType.names().possibleAttributeBuilder(possibleBuilderMethod.getSimpleName())) {
                    return false;
                }
                ExecutableElement candidateMethod = (ExecutableElement)possibleBuilderMethod;
                TypeKind kind = candidateMethod.getReturnType().getKind();
                return possibleBuilderMethod.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC)) && candidateMethod.getParameters().isEmpty() && candidateMethod.getReturnType().getKind() == TypeKind.DECLARED && !kind.isPrimitive() && kind != TypeKind.ARRAY;
            }
            if (!onValueType && possibleBuilderMethod.getKind() == ElementKind.CONSTRUCTOR) {
                if (!valueAttribute.containingType.names().newTokenInAttributeBuilder()) {
                    return false;
                }
                ExecutableElement candidateConstructor = (ExecutableElement)possibleBuilderMethod;
                return candidateConstructor.getModifiers().contains((Object)Modifier.PUBLIC) && candidateConstructor.getTypeParameters().isEmpty();
            }
            return false;
        }

        private static boolean isPossibleBuilderClass(Element possibleBuilderClass, $ValueAttribute valueAttribute) {
            if (possibleBuilderClass.getKind() == ElementKind.CLASS) {
                return possibleBuilderClass.getModifiers().contains((Object)Modifier.STATIC) && possibleBuilderClass.getKind() == ElementKind.CLASS && valueAttribute.containingType.names().possibleAttributeBuilder(possibleBuilderClass.getSimpleName());
            }
            return false;
        }

        protected static boolean isPossibleCopyMethod($ValueAttribute valueAttribute, Element possibleCopyMethod, boolean onValueType) {
            if (possibleCopyMethod.getKind() == ElementKind.METHOD) {
                if (!valueAttribute.containingType.names().possibleAttributeBuilder(possibleCopyMethod.getSimpleName())) {
                    return false;
                }
                ExecutableElement candidateCopyMethod = (ExecutableElement)possibleCopyMethod;
                Types typeUtils = valueAttribute.containingType.constitution.protoclass().environment().processing().getTypeUtils();
                if (candidateCopyMethod.getParameters().size() == 1 && typeUtils.isSameType(candidateCopyMethod.getParameters().get(0).asType(), valueAttribute.containedTypeElement.asType())) {
                    TypeKind kind = candidateCopyMethod.getReturnType().getKind();
                    return !kind.isPrimitive() && kind != TypeKind.ARRAY;
                }
                if (onValueType && candidateCopyMethod.getParameters().isEmpty() && !candidateCopyMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                    TypeKind kind = candidateCopyMethod.getReturnType().getKind();
                    return !kind.isPrimitive() && kind != TypeKind.ARRAY;
                }
            } else if (!onValueType && possibleCopyMethod.getKind() == ElementKind.CONSTRUCTOR) {
                if (!valueAttribute.containingType.names().newTokenInAttributeBuilder()) {
                    return false;
                }
                ExecutableElement candidateConstructor = (ExecutableElement)possibleCopyMethod;
                return candidateConstructor.getParameters().size() == 1 && candidateConstructor.getParameters().get(0).asType().equals(valueAttribute.containedTypeElement.asType());
            }
            return false;
        }
    }

    @Value.Immutable(builder=false)
    static abstract class FirstPartyStrategy
    implements Strategy {
        FirstPartyStrategy() {
        }

        @Value.Parameter
        abstract $ValueAttribute valueAttribute();

        @Override
        public boolean isAttributeBuilder() {
            return this.valueAttribute().attributeValueType != null && this.valueAttribute().attributeValueType.isUseBuilder();
        }

        @Override
        public $AttributeBuilderDescriptor getAttributeBuilderDescriptor() {
            $ValueAttribute attribute = this.valueAttribute();
            $ValueType type = attribute.attributeValueType;
            return $ImmutableAttributeBuilderDescriptor.builder().attributeName(attribute.name()).valueToBuilderTarget($AttributeBuilderDescriptor.ValueToBuilderTarget.BUILDER_INSTANCE).valueToBuilderMethod(type.names().from).buildMethod(type.names().build).qualifiedValueTypeName(type.typeValue().toString()).qualifiedBuilderTypeName(type.typeBuilder().toString()).qualifiedBuilderConstructorMethod(type.factoryBuilder().toString()).build();
        }
    }

    static interface Strategy {
        public boolean isAttributeBuilder();

        public $AttributeBuilderDescriptor getAttributeBuilderDescriptor();
    }
}

