/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u001f\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "add", "", "key", "value", "dumpValue", "get", "sourceFile", "remove", "removeValues", "removed", "", "set", "values", "kotlin-build-common"})
public final class SourceToJsOutputMap
extends BasicStringMap<Collection<? extends String>> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public SourceToJsOutputMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(storageFile, StringCollectionExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    public final synchronized void add(@NotNull File key, @NotNull File value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getStorage().append(this.pathConverter.toPath(key), CollectionsKt.listOf((Object)this.pathConverter.toPath(value)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> get(@NotNull File sourceFile) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection2 = (Collection)this.getStorage().get(this.pathConverter.toPath(sourceFile));
        if (collection2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(this.pathConverter.toFile((String)it));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void set(@NotNull File key, @NotNull Collection<? extends File> values) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            this.remove(key);
            return;
        }
        Iterable iterable = values;
        String string = this.pathConverter.toPath(key);
        LazyStorage<String, List> lazyStorage = this.getStorage();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.pathConverter.toPath((File)it));
        }
        collection = (List)destination$iv$iv;
        lazyStorage.set(string, (List)collection);
    }

    public final synchronized void remove(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getStorage().remove(this.pathConverter.toPath(key));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void removeValues(@NotNull File key, @NotNull Set<? extends File> removed) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        Iterable $this$filter$iv = this.get(key);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!removed.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }
}

