/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.consistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.consistent.ConsistentAnalysisFormat;
import sbt.internal.inc.consistent.ConsistentFileAnalysisStore$;
import sbt.internal.inc.consistent.Deserializer;
import sbt.internal.inc.consistent.ParallelGzipOutputStream;
import sbt.internal.inc.consistent.Serializer;
import sbt.internal.inc.consistent.SerializerFactory;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0005\u0005%t!B\f\u0019\u0011\u0003\tc!B\u0012\u0019\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003q\u0003bB*\u0002#\u0003%\t\u0001\u0016\u0005\b?\u0006\t\n\u0011\"\u0001a\u0011\u0015\u0011\u0017\u0001\"\u0001d\u0011\u0015\u0011\u0017\u0001\"\u0001f\u0011\u0015\u0011\u0017\u0001\"\u0001i\u0011\u001di\u0017!%A\u0005\u0002\u00014AA\\\u0001\u0007_\"A\u0001H\u0003B\u0001B\u0003%\u0011\b\u0003\u0005x\u0015\t\u0005\t\u0015!\u0003y\u0011!Y(B!A!\u0002\u0013a\b\u0002C(\u000b\u0005\u0003\u0005\u000b\u0011\u0002)\t\r-RA\u0011AA\u0012\u0011\u001d\t\tD\u0003C\u0001\u0003gAq!!\u0012\u000b\t\u0003\t9\u0005C\u0004\u0002V)!\t!a\u0016\b\u0013\u0005e\u0013!!A\t\n\u0005mc\u0001\u00038\u0002\u0003\u0003EI!!\u0018\t\r-\"B\u0011AA0\u0011%\t\t\u0007FI\u0001\n\u0003\t\u0019'A\u000eD_:\u001c\u0018n\u001d;f]R4\u0015\u000e\\3B]\u0006d\u0017p]5t'R|'/\u001a\u0006\u00033i\t!bY8og&\u001cH/\u001a8u\u0015\tYB$A\u0002j]\u000eT!!\b\u0010\u0002\u0011%tG/\u001a:oC2T\u0011aH\u0001\u0004g\n$8\u0001\u0001\t\u0003E\u0005i\u0011\u0001\u0007\u0002\u001c\u0007>t7/[:uK:$h)\u001b7f\u0003:\fG._:jgN#xN]3\u0014\u0005\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\u0005!A/\u001a=u)\u0015ys'Q%O!\t\u0001T'D\u00012\u0015\t\u00114'A\u0004d_6\u0004\u0018\u000e\\3\u000b\u0003Q\nQ\u0001_:ci&L!AN\u0019\u0003\u001b\u0005s\u0017\r\\=tSN\u001cFo\u001c:f\u0011\u0015A4\u00011\u0001:\u0003\u00111\u0017\u000e\\3\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AA5p\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\t\u0019KG.\u001a\u0005\u0006\u0005\u000e\u0001\raQ\u0001\b[\u0006\u0004\b/\u001a:t!\t!u)D\u0001F\u0015\t1\u0015'\u0001\u0005b]\u0006d\u0017p]5t\u0013\tAUI\u0001\tSK\u0006$wK]5uK6\u000b\u0007\u000f]3sg\"9!j\u0001I\u0001\u0002\u0004Y\u0015\u0001B:peR\u0004\"A\n'\n\u00055;#a\u0002\"p_2,\u0017M\u001c\u0005\b\u001f\u000e\u0001\n\u00111\u0001Q\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7\u0011\u0005\u0019\n\u0016B\u0001*(\u0005\rIe\u000e^\u0001\u000fi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005)&FA&WW\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003%)hn\u00195fG.,GM\u0003\u0002]O\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yK&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qA/\u001a=uI\u0011,g-Y;mi\u0012\"T#A1+\u0005A3\u0016A\u00022j]\u0006\u0014\u0018\u0010\u0006\u00020I\")\u0001H\u0002a\u0001sQ\u0019qFZ4\t\u000ba:\u0001\u0019A\u001d\t\u000b\t;\u0001\u0019A\"\u0015\u000b=J'n\u001b7\t\u000baB\u0001\u0019A\u001d\t\u000b\tC\u0001\u0019A\"\t\u000b)C\u0001\u0019A&\t\u000f=C\u0001\u0013!a\u0001!\u0006\u0001\"-\u001b8bef$C-\u001a4bk2$H\u0005\u000e\u0002\u0007\u0003N#xN]3\u0016\u000bA\f\u0019!a\u0006\u0014\u0007)\tx\u0006\u0005\u0002sk6\t1O\u0003\u0002u{\u0005!A.\u00198h\u0013\t18O\u0001\u0004PE*,7\r^\u0001\u0007M>\u0014X.\u0019;\u0011\u0005\tJ\u0018B\u0001>\u0019\u0005a\u0019uN\\:jgR,g\u000e^!oC2L8/[:G_Jl\u0017\r^\u0001\u0003g\u001a\u0004RAI?\u0000\u0003+I!A \r\u0003#M+'/[1mSj,'OR1di>\u0014\u0018\u0010\u0005\u0003\u0002\u0002\u0005\rA\u0002\u0001\u0003\b\u0003\u000bQ!\u0019AA\u0004\u0005\u0005\u0019\u0016\u0003BA\u0005\u0003\u001f\u00012AJA\u0006\u0013\r\tia\n\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0013\u0011C\u0005\u0004\u0003'A\"AC*fe&\fG.\u001b>feB!\u0011\u0011AA\f\t\u001d\tIB\u0003b\u0001\u00037\u0011\u0011\u0001R\t\u0005\u0003\u0013\ti\u0002E\u0002#\u0003?I1!!\t\u0019\u00051!Um]3sS\u0006d\u0017N_3s))\t)#!\u000b\u0002,\u00055\u0012q\u0006\t\u0007\u0003OQq0!\u0006\u000e\u0003\u0005AQ\u0001O\bA\u0002eBQa^\bA\u0002aDQa_\bA\u0002qDqaT\b\u0011\u0002\u0003\u0007\u0001+A\u0002tKR$B!!\u000e\u0002<A\u0019a%a\u000e\n\u0007\u0005erE\u0001\u0003V]&$\bbBA\u001f!\u0001\u0007\u0011qH\u0001\u0011C:\fG._:jg\u000e{g\u000e^3oiN\u00042\u0001MA!\u0013\r\t\u0019%\r\u0002\u0011\u0003:\fG._:jg\u000e{g\u000e^3oiN\f1aZ3u)\t\tI\u0005\u0005\u0004\u0002L\u0005E\u0013qH\u0007\u0003\u0003\u001bR1!a\u0014>\u0003\u0011)H/\u001b7\n\t\u0005M\u0013Q\n\u0002\t\u001fB$\u0018n\u001c8bY\u0006IQO\\:bM\u0016<U\r\u001e\u000b\u0003\u0003\u007f\ta!Q*u_J,\u0007cAA\u0014)M\u0011A#\n\u000b\u0003\u00037\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u00021\u0002f\u0005\u001dDaBA\u0003-\t\u0007\u0011q\u0001\u0003\b\u000331\"\u0019AA\u000e\u0001")
public final class ConsistentFileAnalysisStore {
    public static int binary$default$4() {
        return ConsistentFileAnalysisStore$.MODULE$.binary$default$4();
    }

    public static AnalysisStore binary(File file, ReadWriteMappers mappers, boolean sort, int parallelism) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file, mappers, sort, parallelism);
    }

    public static AnalysisStore binary(File file, ReadWriteMappers mappers) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file, mappers);
    }

    public static AnalysisStore binary(File file) {
        return ConsistentFileAnalysisStore$.MODULE$.binary(file);
    }

    public static int text$default$4() {
        return ConsistentFileAnalysisStore$.MODULE$.text$default$4();
    }

    public static boolean text$default$3() {
        return ConsistentFileAnalysisStore$.MODULE$.text$default$3();
    }

    public static AnalysisStore text(File file, ReadWriteMappers mappers, boolean sort, int parallelism) {
        return ConsistentFileAnalysisStore$.MODULE$.text(file, mappers, sort, parallelism);
    }

    private static final class AStore<S extends Serializer, D extends Deserializer>
    implements AnalysisStore {
        private final File file;
        private final ConsistentAnalysisFormat format;
        private final SerializerFactory<S, D> sf;
        private final int parallelism;

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            try (FileOutputStream fout = new FileOutputStream(tmpAnalysisFile);){
                ParallelGzipOutputStream gout = new ParallelGzipOutputStream(fout, this.parallelism);
                S ser = this.sf.serializerFor(gout);
                this.format.write((Serializer)ser, analysis, setup);
                gout.close();
            }
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> this.unsafeGet())).toOptional();
        }

        public AnalysisContents unsafeGet() {
            return (AnalysisContents)Using$.MODULE$.gzipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable)in -> {
                Object deser = $this.sf.deserializerFor((InputStream)in);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read((Deserializer)deser);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                CompileAnalysis analysis2 = (CompileAnalysis)tuple22._1();
                MiniSetup setup2 = (MiniSetup)tuple22._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public AStore(File file, ConsistentAnalysisFormat format, SerializerFactory<S, D> sf, int parallelism) {
            this.file = file;
            this.format = format;
            this.sf = sf;
            this.parallelism = parallelism;
        }
    }
}

