/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.consistent;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import sbt.internal.inc.consistent.BinaryDeserializer;
import sbt.internal.inc.consistent.BinarySerializer;
import sbt.internal.inc.consistent.SerializerFactory;
import sbt.internal.inc.consistent.TextDeserializer;
import sbt.internal.inc.consistent.TextSerializer;

public final class SerializerFactory$ {
    public static final SerializerFactory$ MODULE$ = new SerializerFactory$();
    private static final SerializerFactory<TextSerializer, TextDeserializer> text = new SerializerFactory<TextSerializer, TextDeserializer>(){

        public TextSerializer serializerFor(OutputStream out) {
            return new TextSerializer(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        }

        public TextDeserializer deserializerFor(InputStream in) {
            return new TextDeserializer(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
        }
    };
    private static final SerializerFactory<BinarySerializer, BinaryDeserializer> binary = new SerializerFactory<BinarySerializer, BinaryDeserializer>(){

        public BinarySerializer serializerFor(OutputStream out) {
            return new BinarySerializer(out);
        }

        public BinaryDeserializer deserializerFor(InputStream in) {
            return new BinaryDeserializer(in);
        }
    };

    public SerializerFactory<TextSerializer, TextDeserializer> text() {
        return text;
    }

    public SerializerFactory<BinarySerializer, BinaryDeserializer> binary() {
        return binary;
    }

    private SerializerFactory$() {
    }
}

