/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_3494;
import net.minecraft.class_5414;

/**
 * A tag implementation that keeps its original form for reserialization.
 *
 * @param <V> element type
 */
final class ConfabricateTag<V> implements class_3494<V> {

    private final List<class_3494.class_3496> serializedForm;
    private final Supplier<class_2378<V>> elementResolver;
    private final Supplier<class_5414<V>> tagResolver;
    @LazyInit private volatile List<V> values;

    /**
     * Create a new lazily initialized tag.
     *
     * @param serializedForm serialized form of the tag
     * @param elementResolver element-based resolver
     * @param tagResolver tag-based resolver
     */
    ConfabricateTag(final List<class_3496> serializedForm, final Supplier<class_2378<V>> elementResolver, final Supplier<class_5414<V>> tagResolver) {
        this.serializedForm = ImmutableList.copyOf(serializedForm);
        this.elementResolver = elementResolver;
        this.tagResolver = tagResolver;
    }

    @Override
    public boolean method_15141(final V entry) {
        return method_15138().contains(entry);
    }

    public List<class_3494.class_3496> serializedForm() {
        return this.serializedForm;
    }

    private List<V> resolve() {
        final ImmutableList.Builder<V> builder = ImmutableList.builder();

        for (class_3494.class_3496 entry : this.serializedForm) {
            if (!entry.method_26790(tag -> this.tagResolver.get().method_30210(tag),
                obj -> this.elementResolver.get().method_10223(obj),
                builder::add)) {
                throw new IllegalArgumentException("Unknown tag entry " + entry);
            }
        }

        return builder.build();
    }

    @Override
    public List<V> method_15138() {
        List<V> values = this.values;
        if (values == null) {
            this.values = values = resolve();
        }
        return values;
    }

}
