/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate;

import ca.stellardrift.confabricate.Confabricate;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;

public final class NbtNodeAdapter {
    private NbtNodeAdapter() {
    }

    public static void tagToNode(Tag tag, ConfigurationNode node) throws IOException {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            for (String key : compoundTag.getKeys()) {
                NbtNodeAdapter.tagToNode(compoundTag.get(key), node.node(new Object[]{key}));
            }
        } else if (tag instanceof ListTag) {
            for (Tag value : (ListTag)tag) {
                NbtNodeAdapter.tagToNode(value, node.appendListNode());
            }
        } else if (tag instanceof StringTag) {
            node.raw((Object)tag.asString());
        } else if (tag instanceof ByteTag) {
            node.raw((Object)((ByteTag)tag).getByte());
        } else if (tag instanceof ShortTag) {
            node.raw((Object)((ShortTag)tag).getShort());
        } else if (tag instanceof IntTag) {
            node.raw((Object)((IntTag)tag).getInt());
        } else if (tag instanceof LongTag) {
            node.raw((Object)((LongTag)tag).getLong());
        } else if (tag instanceof FloatTag) {
            node.raw((Object)Float.valueOf(((FloatTag)tag).getFloat()));
        } else if (tag instanceof DoubleTag) {
            node.raw((Object)((DoubleTag)tag).getDouble());
        } else if (tag instanceof ByteArrayTag) {
            if (node.options().acceptsType(byte[].class)) {
                node.raw((Object)((ByteArrayTag)tag).getByteArray());
            } else {
                node.raw(null);
                for (byte b : ((ByteArrayTag)tag).getByteArray()) {
                    node.appendListNode().raw((Object)b);
                }
            }
        } else if (tag instanceof IntArrayTag) {
            if (node.options().acceptsType(int[].class)) {
                node.raw((Object)((IntArrayTag)tag).getIntArray());
            } else {
                node.raw(null);
                for (int i : ((IntArrayTag)tag).getIntArray()) {
                    node.appendListNode().raw((Object)i);
                }
            }
        } else if (tag instanceof LongArrayTag) {
            if (node.options().acceptsType(long[].class)) {
                node.raw((Object)((LongArrayTag)tag).getLongArray());
            } else {
                node.raw(null);
                for (long l : ((LongArrayTag)tag).getLongArray()) {
                    node.appendListNode().raw((Object)l);
                }
            }
        } else if (!(tag instanceof EndTag)) {
            throw new IOException("Unknown tag type: " + tag.getClass());
        }
    }

    public static Tag nodeToTag(ConfigurationNode node) throws IOException {
        if (node.isMap()) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry ent : node.childrenMap().entrySet()) {
                tag.put(ent.getKey().toString(), NbtNodeAdapter.nodeToTag((ConfigurationNode)ent.getValue()));
            }
            return tag;
        }
        if (node.isList()) {
            ListTag list = new ListTag();
            for (ConfigurationNode child : node.childrenList()) {
                list.add((Object)NbtNodeAdapter.nodeToTag(child));
            }
            return list;
        }
        Object obj = node.raw();
        if (obj instanceof byte[]) {
            return new ByteArrayTag((byte[])obj);
        }
        if (obj instanceof int[]) {
            return new IntArrayTag((int[])obj);
        }
        if (obj instanceof long[]) {
            return new LongArrayTag((long[])obj);
        }
        if (obj instanceof Byte) {
            return ByteTag.of((byte)((Byte)obj));
        }
        if (obj instanceof Short) {
            return ShortTag.of((short)((Short)obj));
        }
        if (obj instanceof Integer) {
            return IntTag.of((int)((Integer)obj));
        }
        if (obj instanceof Long) {
            return LongTag.of((long)((Long)obj));
        }
        if (obj instanceof Float) {
            return FloatTag.of((float)((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return DoubleTag.of((double)((Double)obj));
        }
        if (obj instanceof String) {
            return StringTag.of((String)((String)obj));
        }
        throw new IOException("Unsupported object type " + (obj == null ? null : obj.getClass()));
    }

    public static ConfigurationNode createEmptyNode() {
        return NbtNodeAdapter.createEmptyNode(Confabricate.confabricateOptions());
    }

    public static ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        return BasicConfigurationNode.root((ConfigurationOptions)options.nativeTypes((Set)ImmutableSet.of(Map.class, List.class, Byte.class, Short.class, Integer.class, Long.class, (Object[])new Class[]{Float.class, Double.class, long[].class, byte[].class, int[].class, String.class})));
    }
}

