/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tag.Tag;
import net.minecraft.tag.TagGroup;
import net.minecraft.util.registry.Registry;

final class ConfabricateTag<V>
implements Tag<V> {
    private final List<Tag.Entry> serializedForm;
    private final Supplier<Registry<V>> elementResolver;
    private final Supplier<TagGroup<V>> tagResolver;
    @LazyInit
    private volatile List<V> values;

    ConfabricateTag(List<Tag.Entry> serializedForm, Supplier<Registry<V>> elementResolver, Supplier<TagGroup<V>> tagResolver) {
        this.serializedForm = ImmutableList.copyOf(serializedForm);
        this.elementResolver = elementResolver;
        this.tagResolver = tagResolver;
    }

    public boolean contains(V entry) {
        return this.values().contains(entry);
    }

    public List<Tag.Entry> serializedForm() {
        return this.serializedForm;
    }

    private List<V> resolve() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tag.Entry entry : this.serializedForm) {
            if (entry.resolve(tag -> this.tagResolver.get().getTag(tag), obj -> this.elementResolver.get().get(obj), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0))) continue;
            throw new IllegalArgumentException("Unknown tag entry " + entry);
        }
        return builder.build();
    }

    public List<V> values() {
        List<V> values = this.values;
        if (values == null) {
            this.values = values = this.resolve();
        }
        return values;
    }
}

