/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.util.Identifier;
import net.minecraft.util.InvalidIdentifierException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class IdentifierSerializer
implements TypeSerializer<Identifier> {
    public static final IdentifierSerializer INSTANCE = new IdentifierSerializer();

    IdentifierSerializer() {
    }

    public Identifier deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        return IdentifierSerializer.fromNode(value);
    }

    public void serialize(@NonNull Type type, @Nullable Identifier obj, @NonNull ConfigurationNode value) {
        IdentifierSerializer.toNode(obj, value);
    }

    static Identifier fromNode(ConfigurationNode node) throws SerializationException {
        if (node.virtual()) {
            return null;
        }
        if (node.isList()) {
            List children = node.childrenList();
            switch (children.size()) {
                case 2: {
                    String key = ((ConfigurationNode)children.get(0)).getString();
                    String value = ((ConfigurationNode)children.get(1)).getString();
                    if (key != null && value != null) {
                        return IdentifierSerializer.createIdentifier(key, value);
                    }
                    throw IdentifierSerializer.listAcceptedFormats();
                }
                case 1: {
                    String combined = ((ConfigurationNode)children.get(0)).getString();
                    if (combined != null) {
                        return IdentifierSerializer.createIdentifier(combined);
                    }
                    throw IdentifierSerializer.listAcceptedFormats();
                }
            }
            throw IdentifierSerializer.listAcceptedFormats();
        }
        String val = node.getString();
        if (val == null) {
            throw IdentifierSerializer.listAcceptedFormats();
        }
        return new Identifier(val);
    }

    static Identifier createIdentifier(String key, String value) throws SerializationException {
        try {
            return new Identifier(key, value);
        }
        catch (InvalidIdentifierException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    static Identifier createIdentifier(String data) throws SerializationException {
        try {
            return new Identifier(data);
        }
        catch (InvalidIdentifierException ex) {
            throw new SerializationException(ex.getMessage());
        }
    }

    private static SerializationException listAcceptedFormats() {
        return new SerializationException("The provided item must be in [<namespace>:]<path> format");
    }

    static void toNode(Identifier ident, ConfigurationNode node) {
        if (ident == null) {
            node.raw(null);
        } else {
            node.raw((Object)ident.toString());
        }
    }
}

