/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.IdentifierSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.Identifier;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class RegistrySerializer<T>
implements TypeSerializer<T> {
    private final Registry<T> registry;

    RegistrySerializer(Registry<T> registry) {
        this.registry = registry;
    }

    public @Nullable T deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        Identifier ident = IdentifierSerializer.fromNode(value);
        if (ident == null) {
            return null;
        }
        return (T)this.registry.get(ident);
    }

    public void serialize(@NonNull Type type, @Nullable T obj, @NonNull ConfigurationNode value) throws SerializationException {
        Identifier ident;
        if (obj == null) {
            value.raw(null);
        }
        if ((ident = this.registry.getId(obj)) == null) {
            throw new SerializationException("Unknown registry element " + obj);
        }
        IdentifierSerializer.toNode(ident, value);
    }
}

