/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.ConfabricateTag;
import ca.stellardrift.confabricate.typeserializers.IdentifierSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.tag.Tag;
import net.minecraft.tag.TagGroup;
import net.minecraft.util.Identifier;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class TagSerializer<V>
implements TypeSerializer<Tag<V>> {
    private final Registry<V> registry;
    private final Supplier<TagGroup<V>> tags;
    private static final String TAG_PREFIX = "#";
    private static final String ID = "id";
    private static final String REQUIRED = "required";

    TagSerializer(Registry<V> registry, Supplier<TagGroup<V>> tags) {
        this.registry = registry;
        this.tags = tags;
    }

    public Tag<V> deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.isList()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (ConfigurationNode child : value.childrenList()) {
                entries.add((Object)this.entryFromNode(child));
            }
            return new ConfabricateTag((List<Tag.Entry>)entries.build(), () -> this.registry, this.tags);
        }
        if (!value.isMap()) {
            String id = value.getString();
            return TagRegistry.create((Identifier)IdentifierSerializer.createIdentifier(id), this.tags);
        }
        String id = value.node(new Object[]{ID}).getString();
        boolean required = value.node(new Object[]{REQUIRED}).getBoolean();
        if (id == null) {
            throw new SerializationException("An ID is required");
        }
        if (required && id.startsWith(TAG_PREFIX)) {
            return TagRegistry.create((Identifier)IdentifierSerializer.createIdentifier(id.substring(1)), this.tags);
        }
        return new ConfabricateTag((List<Tag.Entry>)ImmutableList.of((Object)this.entryFromNode(value)), () -> this.registry, this.tags);
    }

    public void serialize(@NonNull Type type, @Nullable Tag<V> obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        if (obj instanceof Tag.Identified) {
            value.set((Object)(TAG_PREFIX + ((Tag.Identified)obj).getId().toString()));
        } else if (obj instanceof ConfabricateTag) {
            ConfabricateTag tag = (ConfabricateTag)obj;
            if (value.childrenList().size() == tag.serializedForm().size()) {
                for (int i = 0; i < tag.serializedForm().size(); ++i) {
                    ConfigurationNode child = value.node(new Object[]{i});
                    try {
                        this.entryToNode(tag.serializedForm().get(i), child);
                        continue;
                    }
                    catch (SerializationException ex) {
                        ex.initPath(() -> ((ConfigurationNode)child).path());
                        throw ex;
                    }
                }
            } else {
                value.raw(null);
                for (Tag.Entry entry : tag.serializedForm()) {
                    this.entryToNode(entry, value.appendListNode());
                }
            }
        } else {
            value.raw(null);
            for (Object element : obj.values()) {
                IdentifierSerializer.toNode(this.registry.getId(element), value.appendListNode());
            }
        }
    }

    private Tag.Entry entryFromNode(ConfigurationNode value) throws SerializationException {
        boolean required;
        String id;
        if (value.isMap()) {
            id = value.node(new Object[]{ID}).getString();
            required = value.node(new Object[]{REQUIRED}).getBoolean();
        } else {
            id = value.getString();
            required = true;
        }
        if (id == null) {
            throw new SerializationException("a tag id field is required to deserialize");
        }
        if (id.startsWith(TAG_PREFIX)) {
            Identifier ident = new Identifier(id.substring(1));
            return required ? new Tag.TagEntry(ident) : new Tag.OptionalTagEntry(ident);
        }
        Identifier ident = new Identifier(id);
        return required ? new Tag.ObjectEntry(ident) : new Tag.OptionalObjectEntry(ident);
    }

    private void entryToNode(Tag.Entry entry, ConfigurationNode target) throws SerializationException {
        if (entry instanceof Tag.ObjectEntry) {
            entry.resolve(id -> null, id -> {
                target.raw((Object)id.toString());
                return null;
            }, val -> {});
        } else if (entry instanceof Tag.OptionalObjectEntry) {
            entry.resolve(id -> null, id -> {
                target.node(new Object[]{ID}).raw((Object)id.toString());
                target.node(new Object[]{REQUIRED}).raw((Object)false);
                return null;
            }, val -> {});
        } else if (entry instanceof Tag.TagEntry) {
            entry.resolve(id -> {
                target.raw((Object)(TAG_PREFIX + id.toString()));
                return null;
            }, id -> null, val -> {});
        } else if (entry instanceof Tag.OptionalTagEntry) {
            entry.resolve(id -> {
                target.node(new Object[]{ID}).raw((Object)(TAG_PREFIX + id.toString()));
                target.node(new Object[]{REQUIRED}).raw((Object)false);
                return null;
            }, id -> null, val -> {});
        }
        throw new SerializationException("Unknown tag entry type " + entry);
    }

    public Tag<V> emptyValue(Type specificType, ConfigurationOptions options) {
        return Tag.of((Set)ImmutableSet.of());
    }
}

