/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.MinecraftSerializers;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import net.minecraft.text.LiteralText;
import net.minecraft.text.Style;
import net.minecraft.text.Text;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class TextSerializer
implements TypeSerializer<Text> {
    static final TypeSerializer<Text> INSTANCE = new TextSerializer();

    private TextSerializer() {
    }

    public Text deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.isMap() || value.isList()) {
            JsonElement element = (JsonElement)MinecraftSerializers.opsFor(value).convertTo((DynamicOps)JsonOps.INSTANCE, (Object)value);
            return Text.Serializer.fromJson((JsonElement)element);
        }
        String text = value.getString();
        if (text == null) {
            return null;
        }
        if (text.startsWith("{")) {
            return Text.Serializer.fromLenientJson((String)text);
        }
        return new LiteralText(text);
    }

    public void serialize(@NonNull Type type, @Nullable Text obj, @NonNull ConfigurationNode value) throws SerializationException {
        LiteralText literal;
        if (obj == null) {
            value.raw(null);
            return;
        }
        if (obj instanceof LiteralText && (literal = (LiteralText)obj).getSiblings().isEmpty() && literal.getStyle().equals((Object)Style.EMPTY)) {
            value.raw((Object)literal.getRawString());
            return;
        }
        value.from((ConfigurationNode)JsonOps.INSTANCE.convertTo(MinecraftSerializers.opsFor(value), Text.Serializer.toJsonTree((Text)obj)));
    }

    public Text emptyValue(Type specificType, ConfigurationOptions options) {
        return new LiteralText("");
    }
}

