/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.mixin.FluidTagsAccessor;
import ca.stellardrift.confabricate.typeserializers.IdentifierSerializer;
import ca.stellardrift.confabricate.typeserializers.RegistrySerializer;
import ca.stellardrift.confabricate.typeserializers.TagSerializer;
import ca.stellardrift.confabricate.typeserializers.TextSerializer;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.Block;
import net.minecraft.client.MinecraftClient;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tag.BlockTags;
import net.minecraft.tag.EntityTypeTags;
import net.minecraft.tag.ItemTags;
import net.minecraft.tag.Tag;
import net.minecraft.tag.TagGroup;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.extra.dfu.v4.DfuSerializers;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class MinecraftSerializers {
    private static final ImmutableSet<Registry<?>> SPECIAL_REGISTRIES = ImmutableSet.of((Object)Registry.CUSTOM_STAT, (Object)Registry.FLUID, (Object)Registry.BLOCK, (Object)Registry.ITEM, (Object)Registry.ENTITY_TYPE);
    @LazyInit
    private static Set<Map.Entry<Type, TypeSerializer<?>>> KNOWN_REGISTRIES;
    private static final TypeToken<Registry<?>> TYPE_REGISTRY_GENERIC;
    private static final Logger LOGGER;
    @LazyInit
    private static TypeSerializerCollection MINECRAFT_COLLECTION;
    @LazyInit
    private static ConfigurateOps DEFAULT_OPS;

    private MinecraftSerializers() {
    }

    static DynamicOps<ConfigurationNode> opsFor(ConfigurationNode node) {
        if (node.options().serializers().equals((Object)MINECRAFT_COLLECTION)) {
            @Nullable ConfigurateOps ops = DEFAULT_OPS;
            if (ops == null) {
                DEFAULT_OPS = ConfigurateOps.builder().factoryFromSerializers(MinecraftSerializers.collection()).readWriteProtection(ConfigurateOps.Protection.NONE).build();
                return DEFAULT_OPS;
            }
            return DEFAULT_OPS;
        }
        return ConfigurateOps.builder().factoryFromNode(node).readWriteProtection(ConfigurateOps.Protection.NONE).build();
    }

    public static <V> TypeSerializer<V> serializer(Codec<V> codec) {
        return DfuSerializers.serializer(codec);
    }

    public static <S> @Nullable Codec<S> codec(TypeToken<S> type) {
        return MinecraftSerializers.codec(type, MinecraftSerializers.collection());
    }

    public static <V> @Nullable Codec<V> codec(TypeToken<V> type, TypeSerializerCollection collection) {
        return DfuSerializers.codec(type, (TypeSerializerCollection)collection);
    }

    public static <T> TypeSerializer<T> forRegistry(Registry<T> registry) {
        return new RegistrySerializer<T>(registry);
    }

    public static TypeSerializerCollection collection() {
        TypeSerializerCollection collection = MINECRAFT_COLLECTION;
        if (collection == null) {
            collection = MINECRAFT_COLLECTION = MinecraftSerializers.populate(TypeSerializerCollection.defaults().childBuilder()).build();
        }
        return collection;
    }

    public static boolean isCommonCollection(TypeSerializerCollection collection) {
        return Objects.requireNonNull(collection, "collection").equals((Object)MINECRAFT_COLLECTION);
    }

    private static boolean shouldRegister(Registry<?> registry) {
        return !SPECIAL_REGISTRIES.contains(registry);
    }

    public static TypeSerializerCollection.Builder populate(TypeSerializerCollection.Builder collection) {
        collection.registerExact(Identifier.class, (TypeSerializer)IdentifierSerializer.INSTANCE).register(Text.class, TextSerializer.INSTANCE);
        for (Map.Entry<Type, TypeSerializer<?>> registry : MinecraftSerializers.knownRegistries()) {
            MinecraftSerializers.registerRegistry(collection, registry.getKey(), registry.getValue());
        }
        collection.register(ItemStack.class, MinecraftSerializers.serializer(ItemStack.CODEC));
        collection.register(CompoundTag.class, MinecraftSerializers.serializer(CompoundTag.CODEC));
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(Fluid.class), Registry.FLUID, () -> FluidTagsAccessor.getRequiredTags().getGroup());
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(Block.class), Registry.BLOCK, BlockTags::getTagGroup);
        MinecraftSerializers.populateTaggedRegistry(collection, new TypeToken<EntityType<?>>(){}, Registry.ENTITY_TYPE, EntityTypeTags::getTagGroup);
        MinecraftSerializers.populateTaggedRegistry(collection, TypeToken.get(Item.class), Registry.ITEM, ItemTags::getTagGroup);
        collection.registerAll(GsonConfigurationLoader.gsonSerializers());
        return collection;
    }

    private static TypeSerializerCollection.Builder populateServer(MinecraftServer server, TypeSerializerCollection.Builder collection) {
        MinecraftSerializers.registerRegistry(collection, DimensionType.class, MinecraftSerializers.forRegistry(server.getRegistryManager().getDimensionTypes()));
        return collection;
    }

    @Environment(value=EnvType.CLIENT)
    private static TypeSerializerCollection.Builder populateClient(MinecraftClient client, TypeSerializerCollection.Builder collection) {
        return collection;
    }

    private static Set<Map.Entry<Type, TypeSerializer<?>>> knownRegistries() {
        ImmutableSet registries = KNOWN_REGISTRIES;
        if (registries == null) {
            ImmutableSet.Builder accumulator = ImmutableSet.builder();
            for (Field registryField : Registry.class.getFields()) {
                if ((registryField.getModifiers() & 9) != 9) continue;
                Type fieldType = registryField.getGenericType();
                if (!GenericTypeReflector.isSuperType((Type)TYPE_REGISTRY_GENERIC.getType(), (Type)fieldType)) continue;
                Type elementType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                try {
                    Registry registry = (Registry)registryField.get(null);
                    if (!MinecraftSerializers.shouldRegister(registry)) continue;
                    accumulator.add(new AbstractMap.SimpleImmutableEntry(elementType, MinecraftSerializers.forRegistry(registry)));
                    LOGGER.debug("Created serializer for Minecraft registry {} with element type {}", (Object)registry, (Object)elementType);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Unable to create serializer for registry of type {} due to access error", (Object)elementType, (Object)e);
                }
            }
            registries = KNOWN_REGISTRIES = accumulator.build();
        }
        return registries;
    }

    private static void registerRegistry(TypeSerializerCollection.Builder collection, Type type, TypeSerializer<?> registry) {
        collection.registerExact(TypeToken.get((Type)type), registry);
    }

    private static <T> void populateTaggedRegistry(TypeSerializerCollection.Builder collection, TypeToken<T> token, Registry<T> registry, Supplier<TagGroup<T>> tagRegistry) {
        Type tagType = TypeFactory.parameterizedClass(Tag.class, (Type[])new Type[]{token.getType()});
        collection.registerExact(TypeToken.get((Type)tagType), new TagSerializer<T>(registry, tagRegistry));
        collection.registerExact(token, new RegistrySerializer<T>(registry));
    }

    static {
        TYPE_REGISTRY_GENERIC = new TypeToken<Registry<?>>(){};
        LOGGER = LogManager.getLogger();
    }
}

