/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import record;

/**
 * A tag implementation that keeps its original form for reserialization.
 *
 * @param <V> element type
 */
final class ConfabricateTag<V> extends class_6885.class_6887<V> {

    private final List<class_3494.class_3496> serializedForm;
    private final Supplier<class_2378<V>> elementResolver;
    @LazyInit private volatile List<class_6880<V>> values;

    /**
     * Create a new lazily initialized tag.
     *
     * @param serializedForm serialized form of the tag
     * @param elementResolver element-based resolver
     * @param tagResolver tag-based resolver
     */
    ConfabricateTag(final List<class_3494.class_3496> serializedForm, final Supplier<class_2378<V>> elementResolver, final Supplier<class_3494<V>> tagResolver) {
        this.serializedForm = ImmutableList.copyOf(serializedForm);
        this.elementResolver = elementResolver;
    }

    public List<class_3494.class_3496> serializedForm() {
        return this.serializedForm;
    }

    private List<class_6880<V>> resolve() {
        final ImmutableList.Builder<class_6880<V>> builder = ImmutableList.builder();

        /*for (final Tag.Entry entry : this.serializedForm) {
            if (!entry.resolve(tag -> this.tagResolver.get().getTag(tag),
                obj -> this.elementResolver.get().get(obj),
                builder::add)) {
                throw new IllegalArgumentException("Unknown tag entry " + entry);
            }
        }*/

        return builder.build();
    }

    @Override
    public List<class_6880<V>> method_40249() {
        List<class_6880<V>> values = this.values;
        if (values == null) {
            this.values = values = this.resolve();
        }
        return values;
    }

    @Override
    public Either<class_6862<V>, List<class_6880<V>>> method_40248() {
        return Either.right(this.method_40249());
    }

    @Override
    public boolean method_40241(final class_6880<V> entry) {
        return false; // TODO
    }

    sealed interface TagEntry<V> {
        class_6885<V> resolve(class_2378<V> registry);

        record Single<V>(class_5321<V> item) implements TagEntry<V> {

            @Override
            public class_6885<V> resolve(final class_2378<V> registry) {
                return RegistryEntryList.of(registry.getOrCreateEntry(this.item));
            }
        }

        record Tag<V>(class_6862<V> tagKey) implements TagEntry<V> {
            @Override
            public class_6885<V> resolve(final class_2378<V> registry) {
                return registry.method_40260(this.tagKey);
            }
        }

    }

}
