/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

import static ca.stellardrift.confabricate.typeserializers.MinecraftSerializers.opsFor;

final class ComponentSerializer implements TypeSerializer<class_2561> {

    static final TypeSerializer<class_2561> INSTANCE = new ComponentSerializer();

    private ComponentSerializer() {}

    @Override
    public class_2561 deserialize(final @NonNull Type type, final @NonNull ConfigurationNode value) throws SerializationException {
        if (value.isMap() || value.isList()) {
            final JsonElement element = opsFor(value).convertTo(JsonOps.INSTANCE, value);
            return class_2561.class_2562.method_10872(element);
        } else {
            final String text = value.getString();
            if (text == null) {
                return null;
            }
            if (text.startsWith("{")) { // Legacy format as JSON
                return class_2561.class_2562.method_10877(text);
            } else {
                return new class_2585(text);
            }
        }
    }

    @Override
    public void serialize(
        final @NonNull Type type,
        final @Nullable class_2561 obj,
        final @NonNull ConfigurationNode value
    ) throws SerializationException {
        if (obj == null) {
            value.raw(null);
            return;
        }

        if (obj instanceof final class_2585 text) {
            if (text.method_10855().isEmpty() && text.method_10866().equals(class_2583.field_24360)) {
                value.raw(text.method_10851());
                return;
            }
        }

        value.from(JsonOps.INSTANCE.convertTo(opsFor(value), class_2561.class_2562.method_10868(obj)));
    }

    @Override
    public class_2561 emptyValue(final Type specificType, final ConfigurationOptions options) {
        return new class_2585("");
    }

}
