/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import java.lang.reflect.Type;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class HolderSerializer<T> extends RegistryBasedSerializer<T, class_6880<T>> {

    HolderSerializer(final class_5455 access, final class_5321<? extends class_2378<T>> registry) {
        super(access, registry);
    }

    @Override
    public @Nullable class_6880<T> deserialize(final @NonNull Type type, final @NonNull ConfigurationNode value) throws SerializationException {
        final class_2960 loc = ResourceLocationSerializer.fromNode(value);
        if (loc == null) {
            return null;
        }

        return this.registry()
            .method_40268(class_5321.method_29179(this.registry, loc));
    }

    @Override
    public void serialize(final @NonNull Type type, final @Nullable class_6880<T> obj,
            final @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.raw(null);
        }

        final class_5321<T> loc = obj.method_40230()
            .orElseThrow(() -> new SerializationException(value, type, "Unknown registry element " + obj));

        if (!loc.method_41185().equals(this.registry.method_29177())) {
            throw new SerializationException(
                value,
                type,
                "Registry of provided Holder (" + loc.method_41185()
                    + ") is not the registry associated with the type to be serialized (" + this.registry.method_29177() + ")"
            );
        }
        ResourceLocationSerializer.toNode(loc.method_29177(), value);
    }

}
