/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

/**
 * An abstract supertype for serializers working with registries.
 *
 * @param <E> registry entry type
 * @param <V> handled config value type
 */
abstract class RegistryBasedSerializer<E, V> implements TypeSerializer<V> {

    private final class_5455 access;
    protected final class_5321<? extends class_2378<E>> registry;

    RegistryBasedSerializer(final class_5455 access, final class_5321<? extends class_2378<E>> registry) {
        this.access = access;
        this.registry = registry;
    }

    protected class_2378<E> uncheckedRegistry() {
        return this.access.method_30530(this.registry);
    }

    protected class_2378<E> registry() throws SerializationException {
        return this.access.method_33310(this.registry)
            .orElseThrow(() -> new SerializationException("No registry " + this.registry + " present in the current context!"));
    }

}
