/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.confabricate.typeserializers;

import java.lang.reflect.Type;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class RegistrySerializer<T> extends RegistryBasedSerializer<T, T> {

    RegistrySerializer(final class_5455 access, final class_5321<? extends class_2378<T>> registry) {
        super(access, registry);
    }

    @Override
    public @Nullable T deserialize(final @NonNull Type type, final @NonNull ConfigurationNode value) throws SerializationException {
        final class_2960 loc = ResourceLocationSerializer.fromNode(value);
        if (loc == null) {
            return null;
        }

        return this.registry().method_10223(loc);
    }

    @Override
    public void serialize(final @NonNull Type type, final @Nullable T obj,
            final @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.raw(null);
        }

        final class_2960 loc = this.registry().method_10221(obj);
        if (loc == null) {
            throw new SerializationException("Unknown registry element " + obj);
        }
        ResourceLocationSerializer.toNode(loc, value);
    }

}
