/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate;

import ca.stellardrift.confabricate.Confabricate;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationNodeFactory;
import org.spongepowered.configurate.ConfigurationOptions;

public final class NbtNodeAdapter {
    private static final ConfigurationNodeFactory<BasicConfigurationNode> FACTORY = new ConfigurationNodeFactory<BasicConfigurationNode>(){

        public BasicConfigurationNode createNode(ConfigurationOptions options) {
            return BasicConfigurationNode.root((ConfigurationOptions)options.nativeTypes(Set.of(Map.class, List.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, long[].class, byte[].class, int[].class, String.class)));
        }
    };

    private NbtNodeAdapter() {
    }

    public static void tagToNode(class_2520 tag, ConfigurationNode node) throws IOException {
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            for (String key : compoundTag.method_10541()) {
                NbtNodeAdapter.tagToNode(compoundTag.method_10580(key), node.node(new Object[]{key}));
            }
        } else if (tag instanceof class_2499) {
            class_2499 list = (class_2499)tag;
            for (class_2520 value : list) {
                NbtNodeAdapter.tagToNode(value, node.appendListNode());
            }
        } else if (tag instanceof class_2519) {
            node.raw((Object)tag.method_10714());
        } else if (tag instanceof class_2481) {
            class_2481 b = (class_2481)tag;
            node.raw((Object)b.method_10698());
        } else if (tag instanceof class_2516) {
            class_2516 s = (class_2516)tag;
            node.raw((Object)s.method_10696());
        } else if (tag instanceof class_2497) {
            class_2497 i = (class_2497)tag;
            node.raw((Object)i.method_10701());
        } else if (tag instanceof class_2503) {
            class_2503 l = (class_2503)tag;
            node.raw((Object)l.method_10699());
        } else if (tag instanceof class_2494) {
            class_2494 f = (class_2494)tag;
            node.raw((Object)Float.valueOf(f.method_10700()));
        } else if (tag instanceof class_2489) {
            class_2489 d = (class_2489)tag;
            node.raw((Object)d.method_10697());
        } else if (tag instanceof class_2479) {
            class_2479 arr = (class_2479)tag;
            if (node.options().acceptsType(byte[].class)) {
                node.raw((Object)arr.method_10521());
            } else {
                node.raw(null);
                for (byte b : arr.method_10521()) {
                    node.appendListNode().raw((Object)b);
                }
            }
        } else if (tag instanceof class_2495) {
            class_2495 arr = (class_2495)tag;
            if (node.options().acceptsType(int[].class)) {
                node.raw((Object)arr.method_10588());
            } else {
                node.raw(null);
                for (int i : arr.method_10588()) {
                    node.appendListNode().raw((Object)i);
                }
            }
        } else if (tag instanceof class_2501) {
            class_2501 arr = (class_2501)tag;
            if (node.options().acceptsType(long[].class)) {
                node.raw((Object)arr.method_10615());
            } else {
                node.raw(null);
                for (long l : arr.method_10615()) {
                    node.appendListNode().raw((Object)l);
                }
            }
        } else if (!(tag instanceof class_2491)) {
            throw new IOException("Unknown tag type: " + tag.getClass());
        }
    }

    public static class_2520 nodeToTag(ConfigurationNode node) throws IOException {
        if (node.isMap()) {
            class_2487 tag = new class_2487();
            for (Map.Entry ent : node.childrenMap().entrySet()) {
                tag.method_10566(ent.getKey().toString(), NbtNodeAdapter.nodeToTag((ConfigurationNode)ent.getValue()));
            }
            return tag;
        }
        if (node.isList()) {
            class_2499 list = new class_2499();
            for (ConfigurationNode child : node.childrenList()) {
                list.add((Object)NbtNodeAdapter.nodeToTag(child));
            }
            return list;
        }
        Object obj = node.raw();
        if (obj instanceof byte[]) {
            byte[] arr = (byte[])obj;
            return new class_2479(arr);
        }
        if (obj instanceof int[]) {
            int[] arr = (int[])obj;
            return new class_2495(arr);
        }
        if (obj instanceof long[]) {
            long[] arr = (long[])obj;
            return new class_2501(arr);
        }
        if (obj instanceof Byte) {
            Byte b = (Byte)obj;
            return class_2481.method_23233((byte)b);
        }
        if (obj instanceof Short) {
            Short s = (Short)obj;
            return class_2516.method_23254((short)s);
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return class_2497.method_23247((int)i);
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return class_2503.method_23251((long)l);
        }
        if (obj instanceof Float) {
            Float f = (Float)obj;
            return class_2494.method_23244((float)f.floatValue());
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return class_2489.method_23241((double)d);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return class_2519.method_23256((String)s);
        }
        throw new IOException("Unsupported object type " + (obj == null ? null : obj.getClass()));
    }

    public static ConfigurationNode createEmptyNode() {
        return FACTORY.createNode(Confabricate.confabricateOptions());
    }

    public static ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        return FACTORY.createNode(options);
    }

    public static ConfigurationNodeFactory<BasicConfigurationNode> nodeFactory() {
        return FACTORY;
    }
}

