/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.ResourceLocationSerializer;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_151;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class ConfabricateHolderSet<V>
extends class_6885.class_6887<V> {
    private final List<TagEntry<V>> serializedForm;
    private final Supplier<class_2378<V>> elementResolver;
    @LazyInit
    private volatile List<class_6880<V>> values;

    ConfabricateHolderSet(List<TagEntry<V>> serializedForm, Supplier<class_2378<V>> elementResolver) {
        this.serializedForm = List.copyOf(serializedForm);
        this.elementResolver = elementResolver;
    }

    public List<TagEntry<V>> serializedForm() {
        return this.serializedForm;
    }

    private List<class_6880<V>> resolve() {
        ImmutableList.Builder builder = ImmutableList.builder();
        class_2378<V> registry = this.elementResolver.get();
        for (TagEntry<V> entry : this.serializedForm) {
            entry.collect(registry, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<class_6880<V>> method_40249() {
        List<class_6880<V>> values = this.values;
        if (values == null) {
            this.values = values = this.resolve();
        }
        return values;
    }

    public Either<class_6862<V>, List<class_6880<V>>> method_40248() {
        return Either.right(this.method_40249());
    }

    public boolean method_40241(class_6880<V> entry) {
        return this.method_40249().contains(entry);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface TagEntry<V> {
        public static final String TAG_PREFIX = "#";
        public static final String ID = "id";
        public static final String REQUIRED = "required";

        public static <E> TagEntry<E> fromNode(class_5321<? extends class_2378<E>> registry, ConfigurationNode value) throws SerializationException {
            boolean required;
            String id;
            if (value.isMap()) {
                id = value.node(new Object[]{ID}).getString();
                required = value.node(new Object[]{REQUIRED}).getBoolean();
            } else {
                id = value.getString();
                required = true;
            }
            if (id == null) {
                throw new SerializationException("a tag id field is required to deserialize");
            }
            try {
                if (id.startsWith(TAG_PREFIX)) {
                    class_2960 loc = new class_2960(id.substring(1));
                    return new Tag(class_6862.method_40092(registry, (class_2960)loc), required);
                }
                class_2960 loc = new class_2960(id);
                return new Single(class_5321.method_29179(registry, (class_2960)loc), required);
            }
            catch (class_151 ex) {
                throw new SerializationException("Invalid resource location " + id);
            }
        }

        public boolean required();

        public void collect(class_2378<V> var1, Consumer<class_6880<V>> var2);

        public void toNode(ConfigurationNode var1) throws SerializationException;

        public record Tag<V>(class_6862<V> tagKey, boolean required) implements TagEntry<V>
        {
            @Override
            public void collect(class_2378<V> registry, Consumer<class_6880<V>> collector) {
                for (class_6880 entry : registry.method_40260(this.tagKey)) {
                    collector.accept(entry);
                }
            }

            @Override
            public void toNode(ConfigurationNode target) throws SerializationException {
                if (this.required) {
                    target.set((Object)(TagEntry.TAG_PREFIX + this.tagKey.comp_327()));
                } else {
                    target.node(new Object[]{TagEntry.ID}).set((Object)(TagEntry.TAG_PREFIX + this.tagKey.comp_327()));
                    target.node(new Object[]{TagEntry.REQUIRED}).set((Object)false);
                }
            }
        }

        public record Single<V>(class_5321<V> item, boolean required) implements TagEntry<V>
        {
            @Override
            public void collect(class_2378<V> registry, Consumer<class_6880<V>> collector) {
                collector.accept(registry.method_40268(this.item));
            }

            @Override
            public void toNode(ConfigurationNode target) throws SerializationException {
                if (this.required) {
                    ResourceLocationSerializer.toNode(this.item.method_29177(), target);
                } else {
                    ResourceLocationSerializer.toNode(this.item.method_29177(), target.node(new Object[]{TagEntry.ID}));
                    target.node(new Object[]{TagEntry.REQUIRED}).set((Object)false);
                }
            }
        }
    }
}

