/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.ConfabricateHolderSet;
import ca.stellardrift.confabricate.typeserializers.RegistryBasedSerializer;
import ca.stellardrift.confabricate.typeserializers.ResourceLocationSerializer;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;

final class HolderSetSerializer<V>
extends RegistryBasedSerializer<V, class_6885<V>> {
    private static final String TAG_PREFIX = "#";
    private static final String ID = "id";
    private static final String REQUIRED = "required";

    HolderSetSerializer(class_5455 access, class_5321<? extends class_2378<V>> registry) {
        super(access, registry);
    }

    public class_6885<V> deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        if (value.isList()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (ConfigurationNode child : value.childrenList()) {
                entries.add(ConfabricateHolderSet.TagEntry.fromNode(this.registry, child));
            }
            return new ConfabricateHolderSet(entries.build(), this::uncheckedRegistry);
        }
        if (!value.isMap()) {
            String id = value.getString();
            return this.registry().method_40260(class_6862.method_40092((class_5321)this.registry, (class_2960)ResourceLocationSerializer.createIdentifier(id)));
        }
        String id = value.node(new Object[]{ID}).getString();
        boolean required = value.node(new Object[]{REQUIRED}).getBoolean();
        if (id == null) {
            throw new SerializationException("An ID is required");
        }
        if (required && id.startsWith(TAG_PREFIX)) {
            return this.registry().method_40260(class_6862.method_40092((class_5321)this.registry, (class_2960)ResourceLocationSerializer.createIdentifier(id.substring(1))));
        }
        return new ConfabricateHolderSet(List.of(ConfabricateHolderSet.TagEntry.fromNode(this.registry, value)), this::uncheckedRegistry);
    }

    public void serialize(@NonNull Type type, @Nullable class_6885<V> obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        if (obj instanceof class_6885.class_6888) {
            value.set((Object)(TAG_PREFIX + ((class_6885.class_6888)obj).method_40251().comp_327().toString()));
        } else if (obj instanceof ConfabricateHolderSet) {
            ConfabricateHolderSet tag = (ConfabricateHolderSet)obj;
            if (value.childrenList().size() == tag.serializedForm().size()) {
                for (int i = 0; i < tag.serializedForm().size(); ++i) {
                    ConfigurationNode child = value.node(new Object[]{i});
                    try {
                        tag.serializedForm().get(i).toNode(child);
                        continue;
                    }
                    catch (SerializationException ex) {
                        ex.initPath(() -> ((ConfigurationNode)child).path());
                        throw ex;
                    }
                }
            } else {
                value.raw(null);
                for (ConfabricateHolderSet.TagEntry entry : tag.serializedForm()) {
                    entry.toNode(value.appendListNode());
                }
            }
        } else {
            value.raw(null);
            for (class_6880 element : (List)obj.method_40248().right().orElseThrow()) {
                ResourceLocationSerializer.toNode(((class_5321)element.method_40230().orElseThrow()).method_29177(), value.appendListNode());
            }
        }
    }

    public class_6885<V> emptyValue(Type specificType, ConfigurationOptions options) {
        return class_6885.method_40242(List.of());
    }
}

