/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.confabricate.typeserializers;

import ca.stellardrift.confabricate.typeserializers.ComponentSerializer;
import ca.stellardrift.confabricate.typeserializers.HolderSerializer;
import ca.stellardrift.confabricate.typeserializers.HolderSetSerializer;
import ca.stellardrift.confabricate.typeserializers.RegistrySerializer;
import ca.stellardrift.confabricate.typeserializers.ResourceLocationSerializer;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v4.ConfigurateOps;
import org.spongepowered.configurate.extra.dfu.v4.DfuSerializers;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class MinecraftSerializers {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<class_5321<? extends class_2378<?>>> SPECIAL_REGISTRIES = Set.of(class_2378.field_25075);
    private static final TypeToken<class_5321<? extends class_2378<?>>> TYPE_RESOURCE_KEY_GENERIC = new TypeToken<class_5321<? extends class_2378<?>>>(){};
    @LazyInit
    private static Set<Map.Entry<Type, class_5321<? extends class_2378<?>>>> KNOWN_REGISTRIES;
    @LazyInit
    private static TypeSerializerCollection MINECRAFT_COLLECTION;
    @LazyInit
    private static ConfigurateOps DEFAULT_OPS;

    private MinecraftSerializers() {
    }

    static DynamicOps<ConfigurationNode> opsFor(ConfigurationNode node) {
        if (node.options().serializers().equals((Object)MINECRAFT_COLLECTION)) {
            @Nullable ConfigurateOps ops = DEFAULT_OPS;
            if (ops == null) {
                DEFAULT_OPS = ConfigurateOps.builder().factoryFromSerializers(MinecraftSerializers.collection()).readWriteProtection(ConfigurateOps.Protection.NONE).build();
                return DEFAULT_OPS;
            }
            return DEFAULT_OPS;
        }
        return ConfigurateOps.builder().factoryFromNode(node).readWriteProtection(ConfigurateOps.Protection.NONE).build();
    }

    public static <V> TypeSerializer<V> serializer(Codec<V> codec) {
        return DfuSerializers.serializer(codec);
    }

    public static <S> @Nullable Codec<S> codec(TypeToken<S> type) {
        return MinecraftSerializers.codec(type, MinecraftSerializers.collection());
    }

    public static <V> @Nullable Codec<V> codec(TypeToken<V> type, TypeSerializerCollection collection) {
        return DfuSerializers.codec(type, (TypeSerializerCollection)collection);
    }

    public static <T> void populateRegistry(TypeSerializerCollection.Builder builder, TypeToken<T> entryType, class_5455 access, class_5321<? extends class_2378<T>> registry) {
        builder.registerExact(entryType, new RegistrySerializer(access, registry));
        builder.registerExact(TypeToken.get((Type)TypeFactory.parameterizedClass(class_6880.class, (Type[])new Type[]{entryType.getType()})), new HolderSerializer(access, registry));
        builder.registerExact(TypeToken.get((Type)TypeFactory.parameterizedClass(class_6885.class, (Type[])new Type[]{entryType.getType()})), new HolderSetSerializer(access, registry));
    }

    public static TypeSerializerCollection collection() {
        TypeSerializerCollection collection = MINECRAFT_COLLECTION;
        if (collection == null) {
            collection = MINECRAFT_COLLECTION = MinecraftSerializers.populate(TypeSerializerCollection.defaults().childBuilder()).build();
        }
        return collection;
    }

    public static boolean isCommonCollection(TypeSerializerCollection collection) {
        return Objects.requireNonNull(collection, "collection").equals((Object)MINECRAFT_COLLECTION);
    }

    private static boolean shouldRegister(class_5321<? extends class_2378<?>> registry) {
        return !SPECIAL_REGISTRIES.contains(registry);
    }

    public static TypeSerializerCollection.Builder populate(TypeSerializerCollection.Builder collection) {
        collection.registerExact(class_2960.class, (TypeSerializer)ResourceLocationSerializer.INSTANCE).register(class_2561.class, ComponentSerializer.INSTANCE);
        for (Map.Entry<Type, class_5321<class_2378<?>>> registry : MinecraftSerializers.knownRegistries()) {
            MinecraftSerializers.registerRegistry(collection, registry.getKey(), class_5455.field_26733, registry.getValue());
        }
        collection.register(class_1799.class, MinecraftSerializers.serializer(class_1799.field_24671));
        collection.register(class_2487.class, MinecraftSerializers.serializer(class_2487.field_25128));
        collection.registerAll(GsonConfigurationLoader.gsonSerializers());
        return collection;
    }

    private static Set<Map.Entry<Type, class_5321<? extends class_2378<?>>>> knownRegistries() {
        ImmutableSet registries = KNOWN_REGISTRIES;
        if (registries == null) {
            ImmutableSet.Builder accumulator = ImmutableSet.builder();
            for (Field registryField : class_2378.class.getFields()) {
                class_5321 registry;
                if ((registryField.getModifiers() & 9) != 9) continue;
                Type fieldType = registryField.getGenericType();
                if (!GenericTypeReflector.isSuperType((Type)TYPE_RESOURCE_KEY_GENERIC.getType(), (Type)fieldType)) continue;
                try {
                    registry = (class_5321)registryField.get(null);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Unable to create serializer for registry of type {} due to access error", (Object)fieldType, (Object)e);
                    continue;
                }
                try {
                    if (!MinecraftSerializers.shouldRegister(registry)) continue;
                    Type registryKeyType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                    Type registryType = registryKeyType instanceof WildcardType ? ((WildcardType)registryKeyType).getUpperBounds()[0] : registryKeyType;
                    Type elementType = ((ParameterizedType)registryType).getActualTypeArguments()[0];
                    accumulator.add(Map.entry(elementType, registry));
                    LOGGER.debug("Created serializer for Minecraft registry {} with element type {}", (Object)registry, (Object)elementType);
                }
                catch (Exception ex) {
                    LOGGER.error("Error attempting to discover registry entry type for {} from field type {}", new Object[]{registry, fieldType, ex});
                }
            }
            registries = KNOWN_REGISTRIES = accumulator.build();
        }
        return registries;
    }

    private static void registerRegistry(TypeSerializerCollection.Builder collection, Type type, Supplier<? extends class_5455> access, class_5321<? extends class_2378<?>> registry) {
        MinecraftSerializers.populateRegistry(collection, TypeToken.get((Type)type), access.get(), registry);
    }
}

